/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.ConflictingTypesException;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.model.ListExpression;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.TypedExpression;
import fr.insee.vtl.model.VtlFunction;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.model.utils.Java8Helpers;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ComparisonVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private static final String unknownOperator = "unknown operator ";
    private final ExpressionVisitor exprVisitor;
    private final GenericFunctionsVisitor genericFunctionsVisitor;

    public ComparisonVisitor(ExpressionVisitor expressionVisitor, GenericFunctionsVisitor genericFunctionsVisitor) {
        this.exprVisitor = Objects.requireNonNull(expressionVisitor);
        this.genericFunctionsVisitor = genericFunctionsVisitor;
    }

    private static Integer compare(Object left, Object right) throws Exception {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Number && right instanceof Number) {
            if (left instanceof Long && right instanceof Long) {
                return Long.compare(((Number)left).longValue(), ((Number)right).longValue());
            }
            return Double.compare(((Number)left).doubleValue(), ((Number)right).doubleValue());
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return Boolean.compare((Boolean)left, (Boolean)right);
        }
        if (left instanceof String && right instanceof String) {
            return ((String)left).compareTo((String)right);
        }
        if (left instanceof Date && right instanceof Date) {
            return ((Date)left).compareTo((Date)right);
        }
        throw new Exception("Comparisons require Comparable params");
    }

    public static Boolean isEqual(Object left, Object right) throws Exception {
        Integer compare = ComparisonVisitor.compare(left, right);
        if (compare == null) {
            return null;
        }
        return compare == 0;
    }

    public static Boolean isNotEqual(Object left, Object right) throws Exception {
        Integer compare = ComparisonVisitor.compare(left, right);
        if (compare == null) {
            return null;
        }
        return compare != 0;
    }

    public static Boolean isLessThan(Object left, Object right) throws Exception {
        Integer compare = ComparisonVisitor.compare(left, right);
        if (compare == null) {
            return null;
        }
        return compare < 0;
    }

    public static Boolean isGreaterThan(Object left, Object right) throws Exception {
        Integer compare = ComparisonVisitor.compare(left, right);
        if (compare == null) {
            return null;
        }
        return compare > 0;
    }

    public static Boolean isLessThanOrEqual(Object left, Object right) throws Exception {
        Integer compare = ComparisonVisitor.compare(left, right);
        if (compare == null) {
            return null;
        }
        return compare <= 0;
    }

    public static Boolean isGreaterThanOrEqual(Object left, Object right) throws Exception {
        Integer compare = ComparisonVisitor.compare(left, right);
        if (compare == null) {
            return null;
        }
        return compare >= 0;
    }

    public static Boolean in(Object obj, List<?> list) {
        if (obj == null) {
            return null;
        }
        return list.contains(obj);
    }

    public static Boolean notIn(Object obj, List<?> list) {
        if (obj == null) {
            return null;
        }
        return !list.contains(obj);
    }

    public ResolvableExpression visitComparisonExpr(VtlParser.ComparisonExprContext ctx) {
        try {
            Token type = ((TerminalNode)ctx.op.getChild(0)).getSymbol();
            ResolvableExpression leftExpression = (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.left);
            List parameters = Java8Helpers.listOf((Object[])new ResolvableExpression[]{leftExpression, (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.right)});
            if (parameters.stream().map(TypedExpression::getType).anyMatch(Object.class::equals)) {
                return ResolvableExpression.withType(Boolean.class).withPosition(VtlScriptEngine.fromContext((ParseTree)ctx)).using((VtlFunction & Serializable)c -> null);
            }
            switch (type.getType()) {
                case 7: {
                    return this.genericFunctionsVisitor.invokeFunction("isEqual", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 11: {
                    return this.genericFunctionsVisitor.invokeFunction("isNotEqual", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 8: {
                    return this.genericFunctionsVisitor.invokeFunction("isLessThan", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 9: {
                    return this.genericFunctionsVisitor.invokeFunction("isGreaterThan", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 12: {
                    return this.genericFunctionsVisitor.invokeFunction("isLessThanOrEqual", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 10: {
                    return this.genericFunctionsVisitor.invokeFunction("isGreaterThanOrEqual", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
            }
            throw new UnsupportedOperationException(unknownOperator + ctx);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    public ResolvableExpression visitInNotInExpr(VtlParser.InNotInExprContext ctx) {
        try {
            List parameters = Java8Helpers.listOf((Object[])new ResolvableExpression[]{(ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.left), (ResolvableExpression)this.visit((ParseTree)ctx.lists())});
            Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
            switch (ctx.op.getType()) {
                case 52: {
                    return this.genericFunctionsVisitor.invokeFunction("in", parameters, pos);
                }
                case 53: {
                    return this.genericFunctionsVisitor.invokeFunction("notIn", parameters, pos);
                }
            }
            throw new IllegalStateException("Unexpected value: " + ctx.op.getType());
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    public ResolvableExpression visitLists(VtlParser.ListsContext ctx) {
        List listExpressions = ctx.constant().stream().map(this.exprVisitor::visitConstant).collect(Collectors.toList());
        Set<Class<?>> types = listExpressions.stream().map(TypedExpression::getType).collect(Collectors.toSet());
        Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
        if (types.size() > 1) {
            throw new VtlRuntimeException(new ConflictingTypesException(types, pos));
        }
        Class type = (Class)types.iterator().next();
        List values = listExpressions.stream().map(expression -> expression.resolve(Java8Helpers.mapOf())).collect(Collectors.toList());
        return ListExpression.withContainedType(values, (Class)type, (Positioned)pos);
    }
}

