/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.utils.TypeChecking;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.VtlFunction;
import fr.insee.vtl.model.exceptions.InvalidTypeException;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.model.utils.Java8Helpers;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

public class ConditionalVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private final ExpressionVisitor exprVisitor;
    private final GenericFunctionsVisitor genericFunctionsVisitor;

    public ConditionalVisitor(ExpressionVisitor expressionVisitor, GenericFunctionsVisitor genericFunctionsVisitor) {
        this.exprVisitor = Objects.requireNonNull(expressionVisitor);
        this.genericFunctionsVisitor = Objects.requireNonNull(genericFunctionsVisitor);
    }

    public static Long ifThenElse(Boolean condition, Long thenExpr, Long elseExpr) {
        if (condition == null) {
            return null;
        }
        return condition != false ? thenExpr : elseExpr;
    }

    public static Double ifThenElse(Boolean condition, Double thenExpr, Double elseExpr) {
        if (condition == null) {
            return null;
        }
        return condition != false ? thenExpr : elseExpr;
    }

    public static String ifThenElse(Boolean condition, String thenExpr, String elseExpr) {
        if (condition == null) {
            return null;
        }
        return condition != false ? thenExpr : elseExpr;
    }

    public static Boolean ifThenElse(Boolean condition, Boolean thenExpr, Boolean elseExpr) {
        if (condition == null) {
            return null;
        }
        return condition != false ? thenExpr : elseExpr;
    }

    public static Long caseFn(Boolean condition, Long thenExpr) {
        if (condition == null) {
            return null;
        }
        return condition != false ? thenExpr : null;
    }

    public static Double caseFn(Boolean condition, Double thenExpr) {
        if (condition == null) {
            return null;
        }
        return condition != false ? thenExpr : null;
    }

    public static String caseFn(Boolean condition, String thenExpr) {
        if (condition == null) {
            return null;
        }
        return condition != false ? thenExpr : null;
    }

    public static Boolean caseFn(Boolean condition, Boolean thenExpr) {
        if (condition == null) {
            return null;
        }
        return condition != false ? thenExpr : null;
    }

    public static Long nvl(Long value, Long defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Double nvl(Double value, Double defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Double nvl(Double value, Long defaultValue) {
        return value == null ? defaultValue.doubleValue() : value.doubleValue();
    }

    public static Double nvl(Long value, Double defaultValue) {
        return value == null ? defaultValue.doubleValue() : value.doubleValue();
    }

    public static String nvl(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Boolean nvl(Boolean value, Boolean defaultValue) {
        return value == null ? defaultValue : value;
    }

    public ResolvableExpression visitIfExpr(VtlParser.IfExprContext ctx) {
        try {
            ResolvableExpression conditionalExpr = (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.conditionalExpr);
            ResolvableExpression thenExpression = (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.thenExpr);
            ResolvableExpression elseExpression = (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.elseExpr);
            Positioned position = VtlScriptEngine.fromContext((ParseTree)ctx);
            ResolvableExpression expression = this.genericFunctionsVisitor.invokeFunction("ifThenElse", Java8Helpers.listOf((Object[])new ResolvableExpression[]{conditionalExpr, thenExpression, elseExpression}), position);
            Class actualType = thenExpression.getType();
            return new CastExpression(position, expression, actualType);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    public ResolvableExpression visitCaseExpr(VtlParser.CaseExprContext ctx) {
        Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
        List exprs = ctx.expr();
        ArrayList<VtlParser.ExprContext> whenExprs = new ArrayList<VtlParser.ExprContext>();
        ArrayList<VtlParser.ExprContext> thenExprs = new ArrayList<VtlParser.ExprContext>();
        for (int i = 0; i < exprs.size() - 1; i += 2) {
            whenExprs.add((VtlParser.ExprContext)exprs.get(i));
            thenExprs.add((VtlParser.ExprContext)exprs.get(i + 1));
        }
        List whenExpressions = whenExprs.stream().map(e -> TypeChecking.assertBoolean((ResolvableExpression)this.exprVisitor.visit((ParseTree)e), (ParseTree)e)).collect(Collectors.toList());
        List thenExpressions = thenExprs.stream().map(arg_0 -> ((ExpressionVisitor)this.exprVisitor).visit(arg_0)).collect(Collectors.toList());
        ResolvableExpression elseExpression = (ResolvableExpression)this.exprVisitor.visit((ParseTree)exprs.get(exprs.size() - 1));
        ArrayList<ResolvableExpression> forTypeCheck = new ArrayList<ResolvableExpression>(thenExpressions);
        forTypeCheck.add(elseExpression);
        if (!TypeChecking.hasSameTypeOrNull(forTypeCheck)) {
            try {
                throw new InvalidTypeException(((ResolvableExpression)forTypeCheck.get(0)).getClass(), Boolean.class, VtlScriptEngine.fromContext((ParseTree)ctx.expr(0)));
            }
            catch (InvalidTypeException e2) {
                throw new RuntimeException(e2);
            }
        }
        Class outputType = elseExpression.getType();
        if (outputType.equals(String.class)) {
            return ResolvableExpression.withType(String.class).withPosition(pos).using((VtlFunction & Serializable)context -> {
                for (int i = 0; i < whenExprs.size(); ++i) {
                    Boolean condition = (Boolean)((ResolvableExpression)whenExpressions.get(i)).resolve(context);
                    if (!condition.booleanValue()) continue;
                    return (String)new CastExpression(pos, (ResolvableExpression)thenExpressions.get(i), outputType).resolve((Map<String, Object>)context);
                }
                return (String)new CastExpression(pos, elseExpression, outputType).resolve((Map<String, Object>)context);
            });
        }
        if (outputType.equals(Double.class)) {
            return ResolvableExpression.withType(Double.class).withPosition(pos).using((VtlFunction & Serializable)context -> {
                for (int i = 0; i < whenExprs.size(); ++i) {
                    Boolean condition = (Boolean)((ResolvableExpression)whenExpressions.get(i)).resolve(context);
                    if (!condition.booleanValue()) continue;
                    return (Double)new CastExpression(pos, (ResolvableExpression)thenExpressions.get(i), outputType).resolve((Map<String, Object>)context);
                }
                return (Double)new CastExpression(pos, elseExpression, outputType).resolve((Map<String, Object>)context);
            });
        }
        if (outputType.equals(Long.class)) {
            return ResolvableExpression.withType(Long.class).withPosition(pos).using((VtlFunction & Serializable)context -> {
                for (int i = 0; i < whenExprs.size(); ++i) {
                    Boolean condition = (Boolean)((ResolvableExpression)whenExpressions.get(i)).resolve(context);
                    if (!condition.booleanValue()) continue;
                    return (Long)new CastExpression(pos, (ResolvableExpression)thenExpressions.get(i), outputType).resolve((Map<String, Object>)context);
                }
                return (Long)new CastExpression(pos, elseExpression, outputType).resolve((Map<String, Object>)context);
            });
        }
        if (outputType.equals(Boolean.class)) {
            return ResolvableExpression.withType(Boolean.class).withPosition(pos).using((VtlFunction & Serializable)context -> {
                for (int i = 0; i < whenExprs.size(); ++i) {
                    Boolean condition = (Boolean)((ResolvableExpression)whenExpressions.get(i)).resolve(context);
                    if (!condition.booleanValue()) continue;
                    return (Boolean)new CastExpression(pos, (ResolvableExpression)thenExpressions.get(i), outputType).resolve((Map<String, Object>)context);
                }
                return (Boolean)new CastExpression(pos, elseExpression, outputType).resolve((Map<String, Object>)context);
            });
        }
        return null;
    }

    public ResolvableExpression visitNvlAtom(VtlParser.NvlAtomContext ctx) {
        try {
            ResolvableExpression expression = (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.left);
            ResolvableExpression defaultExpression = (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.right);
            Positioned position = VtlScriptEngine.fromContext((ParseTree)ctx);
            return this.genericFunctionsVisitor.invokeFunction("nvl", Java8Helpers.listOf((Object[])new ResolvableExpression[]{expression, defaultExpression}), position);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    static class CastExpression
    extends ResolvableExpression {
        private final Class<?> type;
        private final ResolvableExpression expression;

        CastExpression(Positioned pos, ResolvableExpression expression, Class<?> type) {
            super(pos);
            this.type = type;
            this.expression = expression;
        }

        public Object resolve(Map<String, Object> context) {
            return this.type.cast(this.expression.resolve(context));
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

