/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.UndefinedVariableException;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.expressions.ComponentExpression;
import fr.insee.vtl.model.ConstantExpression;
import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.DatasetExpression;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.model.VtlFunction;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;

public class VarIdVisitor
extends VtlBaseVisitor<ResolvableExpression>
implements Serializable {
    private final Map<String, Object> context;

    public VarIdVisitor(Map<String, Object> context) {
        this.context = Objects.requireNonNull(context);
    }

    public ResolvableExpression visitVarID(VtlParser.VarIDContext ctx) {
        String variableName = ctx.getText();
        Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
        if (!this.context.containsKey(variableName)) {
            throw new VtlRuntimeException(new UndefinedVariableException(variableName, pos));
        }
        Object value = this.context.get(variableName);
        if (value instanceof Dataset) {
            return DatasetExpression.of((Dataset)((Dataset)value), (Positioned)pos);
        }
        if (value instanceof Structured.Component) {
            Structured.Component component = (Structured.Component)value;
            return new ComponentExpression(component, pos);
        }
        if (value instanceof Integer) {
            value = (long)((Integer)value).intValue();
        }
        if (value instanceof Float) {
            value = (double)((Float)value).floatValue();
        }
        if (value == null) {
            return ResolvableExpression.withType(Object.class).withPosition(pos).using((VtlFunction & Serializable)c -> c.get(variableName));
        }
        return new ConstantExpression(value, pos);
    }
}

