/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression.functions;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.model.utils.Java8Helpers;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

public class ComparisonFunctionsVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private final ExpressionVisitor exprVisitor;
    private final GenericFunctionsVisitor genericFunctionsVisitor;

    public static Boolean between(Number operand, Number from, Number to) {
        if (operand == null || from == null || to == null) {
            return null;
        }
        BigDecimal operandValue = operand instanceof Long ? BigDecimal.valueOf(operand.longValue()) : BigDecimal.valueOf(operand.doubleValue());
        BigDecimal fromValue = from instanceof Long ? BigDecimal.valueOf(from.longValue()) : BigDecimal.valueOf(from.doubleValue());
        BigDecimal toValue = to instanceof Long ? BigDecimal.valueOf(to.longValue()) : BigDecimal.valueOf(to.doubleValue());
        return operandValue.compareTo(fromValue) >= 0 && operandValue.compareTo(toValue) <= 0;
    }

    public static Boolean charsetMatch(String operandValue, String patternValue) {
        if (operandValue == null || patternValue == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(patternValue);
        Matcher matcher = pattern.matcher(operandValue);
        return matcher.matches();
    }

    public static Boolean isNull(Object obj) {
        if (obj == null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public ComparisonFunctionsVisitor(ExpressionVisitor expressionVisitor, GenericFunctionsVisitor genericFunctionsVisitor) {
        this.exprVisitor = Objects.requireNonNull(expressionVisitor);
        this.genericFunctionsVisitor = Objects.requireNonNull(genericFunctionsVisitor);
    }

    public ResolvableExpression visitBetweenAtom(VtlParser.BetweenAtomContext ctx) {
        try {
            List parameters = Java8Helpers.listOf((Object[])new ResolvableExpression[]{(ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.op), (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.from_), (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.to_)});
            return this.genericFunctionsVisitor.invokeFunction("between", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    public ResolvableExpression visitCharsetMatchAtom(VtlParser.CharsetMatchAtomContext ctx) {
        try {
            List parameters = Java8Helpers.listOf((Object[])new ResolvableExpression[]{(ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.op), (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.pattern)});
            return this.genericFunctionsVisitor.invokeFunction("charsetMatch", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    public ResolvableExpression visitIsNullAtom(VtlParser.IsNullAtomContext ctx) {
        try {
            List parameters = Java8Helpers.listOf((Object[])new ResolvableExpression[]{(ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.expr())});
            return this.genericFunctionsVisitor.invokeFunction("isNull", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }
}

