/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression.functions;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.FunctionNotFoundException;
import fr.insee.vtl.engine.exceptions.InvalidArgumentException;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.expressions.CastExpression;
import fr.insee.vtl.engine.expressions.ComponentExpression;
import fr.insee.vtl.engine.expressions.FunctionExpression;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.DatasetExpression;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ProcessingEngine;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.model.TypedExpression;
import fr.insee.vtl.model.VtlFunction;
import fr.insee.vtl.model.VtlMethod;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.model.utils.Java8Helpers;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.threeten.extra.Interval;
import org.threeten.extra.PeriodDuration;

public class GenericFunctionsVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private static final String result = "result";
    private final VtlScriptEngine engine;
    private final ExpressionVisitor exprVisitor;

    public GenericFunctionsVisitor(ExpressionVisitor expressionVisitor, VtlScriptEngine engine) {
        this.engine = Objects.requireNonNull(engine);
        this.exprVisitor = Objects.requireNonNull(expressionVisitor);
    }

    private static Class<?> getOutputClass(Integer basicScalarType, String basicScalarText) {
        switch (basicScalarType) {
            case 173: {
                return String.class;
            }
            case 175: {
                return Long.class;
            }
            case 172: {
                return Double.class;
            }
            case 169: {
                return Boolean.class;
            }
            case 170: {
                return Instant.class;
            }
            case 211: {
                return PeriodDuration.class;
            }
            case 171: {
                return Interval.class;
            }
        }
        throw new UnsupportedOperationException("basic scalar type " + basicScalarText + " unsupported");
    }

    public List<DatasetExpression> splitToMonoMeasure(DatasetExpression dataset) {
        ProcessingEngine proc = this.engine.getProcessingEngine();
        List identifiers = dataset.getIdentifiers();
        return dataset.getMeasures().stream().map(measure -> {
            List idAndMeasure = Stream.concat(identifiers.stream(), Stream.of(measure)).map(Structured.Component::getName).collect(Collectors.toList());
            return proc.executeProject(dataset, idAndMeasure);
        }).collect(Collectors.toList());
    }

    public ResolvableExpression invokeFunction(String funcName, List<ResolvableExpression> parameters, Positioned position) throws VtlScriptException {
        try {
            List measures;
            DatasetExpression finalRes;
            List noMonoDs = parameters.stream().filter(e -> e instanceof DatasetExpression && ((DatasetExpression)e).isMonoMeasure() == false).map(ds -> (DatasetExpression)ds).collect(Collectors.toList());
            if (noMonoDs.size() > 2) {
                throw new VtlRuntimeException(new InvalidArgumentException("too many no mono-measure datasets (" + noMonoDs.size() + ")", position));
            }
            ProcessingEngine proc = this.engine.getProcessingEngine();
            List<Class> parameterTypes = parameters.stream().map(TypedExpression::getType).collect(Collectors.toList());
            VtlMethod method = this.engine.findGlobalMethod(funcName, parameterTypes);
            if (parameters.stream().noneMatch(DatasetExpression.class::isInstance) || method != null) {
                if (method == null) {
                    method = this.engine.findMethod(funcName, parameterTypes);
                }
                return new FunctionExpression(method, parameters, position);
            }
            if (noMonoDs.isEmpty()) {
                finalRes = this.invokeFunctionOnDataset(funcName, parameters, position);
            } else {
                measures = ((DatasetExpression)noMonoDs.get(0)).getDataStructure().getMeasures();
                HashMap<String, DatasetExpression> results = new HashMap<String, DatasetExpression>();
                for (Structured.Component measure : measures) {
                    List<ResolvableExpression> params = parameters.stream().map(p -> {
                        if (p instanceof DatasetExpression) {
                            DatasetExpression ds = (DatasetExpression)p;
                            List idAndMeasure = Stream.concat(ds.getIdentifiers().stream(), Stream.of(measure)).map(Structured.Component::getName).collect(Collectors.toList());
                            return proc.executeProject(ds, idAndMeasure);
                        }
                        return p;
                    }).collect(Collectors.toList());
                    results.put(measure.getName(), this.invokeFunctionOnDataset(funcName, params, position));
                }
                finalRes = proc.executeInnerJoin(results);
            }
            if (finalRes instanceof DatasetExpression && (measures = finalRes.getMeasures()).size() == 1 && ((Structured.Component)measures.get(0)).getType().equals(Boolean.class)) {
                return proc.executeRename(finalRes, Java8Helpers.mapOf((Object)((Structured.Component)measures.get(0)).getName(), (Object)"bool_var"));
            }
            return finalRes;
        }
        catch (NoSuchMethodException e2) {
            throw new VtlRuntimeException(new FunctionNotFoundException(e2.getMessage(), position));
        }
    }

    private DatasetExpression invokeFunctionOnDataset(String funcName, List<ResolvableExpression> parameters, Positioned position) throws NoSuchMethodException, VtlScriptException {
        ProcessingEngine proc = this.engine.getProcessingEngine();
        HashMap monoExprs = new HashMap();
        HashSet measureNames = new HashSet();
        Map<String, DatasetExpression> dsExprs = parameters.stream().filter(DatasetExpression.class::isInstance).map(e -> (DatasetExpression)e).map(ds -> {
            if (Boolean.FALSE.equals(ds.isMonoMeasure())) {
                throw new VtlRuntimeException(new InvalidArgumentException("mono-measure dataset expected", (Positioned)ds));
            }
            String uniqueName = "arg" + ds.hashCode();
            Structured.Component measure = (Structured.Component)ds.getMeasures().get(0);
            String measureName = measure.getName();
            measureNames.add(measureName);
            ds = proc.executeRename(ds, Java8Helpers.mapOf((Object)measureName, (Object)uniqueName));
            Structured.Component renamedComponent = new Structured.Component(uniqueName, measure.getType(), measure.getRole(), measure.getNullable());
            monoExprs.put(uniqueName, new ComponentExpression(renamedComponent, (Positioned)ds));
            return ds;
        }).collect(Collectors.toMap(e -> "arg" + e.hashCode(), e -> e));
        if (measureNames.size() != 1) {
            throw new VtlRuntimeException(new InvalidArgumentException("mono-measure datasets don't contain same measures (number or names)", position));
        }
        DatasetExpression ds2 = proc.executeInnerJoin(dsExprs);
        List<ResolvableExpression> normalizedParams = parameters.stream().map(e -> monoExprs.getOrDefault("arg" + e.hashCode(), e)).collect(Collectors.toList());
        List<Class> parametersTypes = normalizedParams.stream().map(TypedExpression::getType).collect(Collectors.toList());
        VtlMethod method = this.engine.findMethod(funcName, parametersTypes);
        FunctionExpression funcExrp = new FunctionExpression(method, normalizedParams, position);
        ds2 = proc.executeCalc(ds2, Java8Helpers.mapOf((Object)result, (Object)((Object)funcExrp)), Java8Helpers.mapOf((Object)result, (Object)Dataset.Role.MEASURE), Java8Helpers.mapOf());
        ds2 = proc.executeProject(ds2, Stream.concat(ds2.getIdentifiers().stream().map(Structured.Component::getName), Stream.of(result)).collect(Collectors.toList()));
        return proc.executeRename(ds2, Java8Helpers.mapOf((Object)result, (Object)((String)measureNames.iterator().next())));
    }

    public ResolvableExpression visitCallDataset(VtlParser.CallDatasetContext ctx) {
        try {
            List<ResolvableExpression> parameters = ctx.parameter().stream().map(arg_0 -> ((ExpressionVisitor)this.exprVisitor).visit(arg_0)).collect(Collectors.toList());
            return this.invokeFunction(ctx.operatorID().getText(), parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    public ResolvableExpression visitCastExprDataset(VtlParser.CastExprDatasetContext ctx) {
        ResolvableExpression expression = (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.expr());
        TerminalNode maskNode = ctx.STRING_CONSTANT();
        String mask = maskNode == null ? null : maskNode.getText().replace("\"", "").replace("YYYY", "yyyy").replace("DD", "dd");
        Token symbol = ((TerminalNode)ctx.basicScalarType().getChild(0)).getSymbol();
        Integer basicScalarType = symbol.getType();
        String basicScalarText = symbol.getText();
        Class<?> outputClass = GenericFunctionsVisitor.getOutputClass(basicScalarType, basicScalarText);
        if (Object.class.equals((Object)expression.getType())) {
            return ResolvableExpression.withType(outputClass).withPosition(VtlScriptEngine.fromContext((ParseTree)ctx)).using((VtlFunction & Serializable)c -> null);
        }
        try {
            return new CastExpression(VtlScriptEngine.fromContext((ParseTree)ctx), expression, mask, outputClass);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }
}

