/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression.functions;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.InvalidArgumentException;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.utils.TypeChecking;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.DatasetExpression;
import fr.insee.vtl.model.ProcessingEngine;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.model.utils.Java8Helpers;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

public class JoinFunctionsVisitor
extends VtlBaseVisitor<DatasetExpression> {
    private static final String mustHaveCommonIdentifiers = "datasets must have common identifiers";
    private final ExpressionVisitor expressionVisitor;
    private final ProcessingEngine processingEngine;

    public JoinFunctionsVisitor(ExpressionVisitor expressionVisitor, ProcessingEngine processingEngine) {
        this.expressionVisitor = Objects.requireNonNull(expressionVisitor);
        this.processingEngine = Objects.requireNonNull(processingEngine);
    }

    public static Optional<List<Structured.Component>> checkSameIdentifiers(Collection<DatasetExpression> datasetExpressions) {
        LinkedHashSet identifiers = new LinkedHashSet();
        for (DatasetExpression datasetExpression : datasetExpressions) {
            Structured.DataStructure structure = datasetExpression.getDataStructure();
            LinkedHashSet<Structured.Component> ids = new LinkedHashSet<Structured.Component>();
            for (Structured.Component component : structure.values()) {
                if (!component.getRole().equals((Object)Dataset.Role.IDENTIFIER)) continue;
                ids.add(component);
            }
            identifiers.add(ids);
        }
        if (identifiers.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(new ArrayList((Collection)identifiers.iterator().next()));
    }

    public DatasetExpression visitJoinExpr(VtlParser.JoinExprContext ctx) {
        if (ctx.LEFT_JOIN() != null) {
            return this.leftJoin(ctx);
        }
        if (ctx.INNER_JOIN() != null) {
            return this.innerJoin(ctx);
        }
        if (ctx.FULL_JOIN() != null) {
            return this.fullJoin(ctx);
        }
        if (ctx.CROSS_JOIN() != null) {
            return this.crossJoin(ctx);
        }
        throw new UnsupportedOperationException("unknown join type");
    }

    private LinkedHashMap<String, DatasetExpression> normalizeDatasets(List<VtlParser.JoinClauseItemContext> joinClauseItems) {
        LinkedHashMap<String, DatasetExpression> datasets = new LinkedHashMap<String, DatasetExpression>();
        ArrayList<String> measures = new ArrayList<String>();
        for (VtlParser.JoinClauseItemContext joinClauseItem : joinClauseItems) {
            String alias;
            VtlParser.ExprContext datasetExpressionContext = joinClauseItem.expr();
            String string = alias = joinClauseItem.alias() != null ? joinClauseItem.alias().IDENTIFIER().getText() : null;
            if (alias == null && !(datasetExpressionContext instanceof VtlParser.VarIdExprContext)) {
                throw new VtlRuntimeException(new InvalidArgumentException("cannot use expression without alias in join clause", VtlScriptEngine.fromContext((ParseTree)datasetExpressionContext)));
            }
            DatasetExpression datasetExpression = (DatasetExpression)TypeChecking.assertTypeExpression((ResolvableExpression)this.expressionVisitor.visit((ParseTree)datasetExpressionContext), Dataset.class, (ParseTree)datasetExpressionContext);
            List<String> dsMeasures = datasetExpression.getDataStructure().values().stream().filter(Structured.Component::isMeasure).map(Structured.Component::getName).collect(Collectors.toList());
            if (alias == null) {
                dsMeasures.forEach(m -> {
                    if (measures.contains(m)) {
                        throw new VtlRuntimeException(new InvalidArgumentException("It is not allowed that two or more Components in the virtual Data Set have the same name (" + m + ")", VtlScriptEngine.fromContext((ParseTree)datasetExpressionContext)));
                    }
                });
                datasets.put(datasetExpressionContext.getText(), datasetExpression);
            } else {
                datasets.put(alias, datasetExpression);
            }
            measures.addAll(dsMeasures);
        }
        return datasets;
    }

    private Map<String, DatasetExpression> renameDuplicates(List<Structured.Component> identifiers, Map<String, DatasetExpression> datasets) {
        Set identifierNames = identifiers.stream().map(Structured.Component::getName).collect(Collectors.toSet());
        LinkedHashSet<String> duplicates = new LinkedHashSet<String>();
        LinkedHashSet<String> uniques = new LinkedHashSet<String>();
        for (DatasetExpression dataset : datasets.values()) {
            for (String name : dataset.getColumnNames()) {
                if (identifierNames.contains(name) || uniques.add(name)) continue;
                duplicates.add(name);
            }
        }
        LinkedHashMap<String, DatasetExpression> result = new LinkedHashMap<String, DatasetExpression>();
        for (Map.Entry<String, DatasetExpression> entry : datasets.entrySet()) {
            String name;
            name = entry.getKey();
            DatasetExpression dataset = entry.getValue();
            LinkedHashMap<String, String> fromTo = new LinkedHashMap<String, String>();
            for (String columnName : dataset.getColumnNames()) {
                if (!duplicates.contains(columnName)) continue;
                fromTo.put(columnName, name + "#" + columnName);
            }
            result.put(name, this.processingEngine.executeRename(dataset, fromTo));
        }
        return result;
    }

    private DatasetExpression removeComponentAlias(DatasetExpression dataset) {
        Set toKeep = dataset.getDataStructure().values().stream().map(Structured.Component::getName).map(n -> n.substring(n.lastIndexOf("#") + 1)).collect(Collectors.toSet());
        List<String> componentNamesWithAlias = dataset.getDataStructure().values().stream().map(Structured.Component::getName).filter(n -> n.contains("#")).collect(Collectors.toList());
        HashMap toFrom = new HashMap();
        componentNamesWithAlias.forEach(n -> {
            String extraction = n.substring(n.lastIndexOf("#") + 1);
            toFrom.put(extraction, n);
        });
        Map<String, String> fromTo = toFrom.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        DatasetExpression renamed = this.processingEngine.executeRename(dataset, fromTo);
        return this.processingEngine.executeProject(renamed, new ArrayList(toKeep));
    }

    private DatasetExpression leftJoin(VtlParser.JoinExprContext ctx) {
        VtlParser.JoinClauseContext joinClauseContext = ctx.joinClause();
        LinkedHashMap<String, DatasetExpression> datasets = this.normalizeDatasets(joinClauseContext.joinClauseItem());
        List<Structured.Component> ids = this.getInnerAndLeftJoinIdentifiers(joinClauseContext, datasets);
        DatasetExpression res = this.processingEngine.executeLeftJoin(this.renameDuplicates(ids, datasets), ids);
        return this.removeComponentAlias(res);
    }

    private DatasetExpression crossJoin(VtlParser.JoinExprContext ctx) {
        VtlParser.JoinClauseWithoutUsingContext joinClauseContext = ctx.joinClauseWithoutUsing();
        LinkedHashMap<String, DatasetExpression> datasets = this.normalizeDatasets(joinClauseContext.joinClauseItem());
        Map<String, DatasetExpression> renamedDatasets = this.renameDuplicates(Java8Helpers.listOf((Object[])new Structured.Component[0]), datasets);
        List identifiers = renamedDatasets.values().stream().flatMap(dsExpr -> dsExpr.getDataStructure().values().stream()).filter(Structured.Component::isIdentifier).collect(Collectors.toList());
        return this.processingEngine.executeCrossJoin(renamedDatasets, identifiers);
    }

    private DatasetExpression fullJoin(VtlParser.JoinExprContext ctx) {
        VtlParser.JoinClauseWithoutUsingContext joinClauseContext = ctx.joinClauseWithoutUsing();
        LinkedHashMap<String, DatasetExpression> datasets = this.normalizeDatasets(joinClauseContext.joinClauseItem());
        List<Structured.Component> commonIdentifiers = JoinFunctionsVisitor.checkSameIdentifiers(((HashMap)datasets).values()).orElseThrow(() -> new VtlRuntimeException(new InvalidArgumentException(mustHaveCommonIdentifiers, VtlScriptEngine.fromContext((ParseTree)joinClauseContext))));
        DatasetExpression res = this.processingEngine.executeFullJoin(this.renameDuplicates(commonIdentifiers, datasets), commonIdentifiers);
        return this.removeComponentAlias(res);
    }

    private DatasetExpression innerJoin(VtlParser.JoinExprContext ctx) {
        VtlParser.JoinClauseContext joinClauseContext = ctx.joinClause();
        LinkedHashMap<String, DatasetExpression> datasets = this.normalizeDatasets(joinClauseContext.joinClauseItem());
        List<Structured.Component> ids = this.getInnerAndLeftJoinIdentifiers(joinClauseContext, datasets);
        DatasetExpression res = this.processingEngine.executeInnerJoin(this.renameDuplicates(ids, datasets), ids);
        return this.removeComponentAlias(res);
    }

    private List<Structured.Component> getInnerAndLeftJoinIdentifiers(VtlParser.JoinClauseContext joinClauseContext, LinkedHashMap<String, DatasetExpression> datasets) {
        List<Structured.Component> commonIdentifiers = new ArrayList<Structured.Component>();
        if (joinClauseContext.USING() == null) {
            commonIdentifiers = JoinFunctionsVisitor.checkSameIdentifiers(datasets.values()).orElseThrow(() -> new VtlRuntimeException(new InvalidArgumentException(mustHaveCommonIdentifiers, VtlScriptEngine.fromContext((ParseTree)joinClauseContext))));
        }
        if (joinClauseContext.USING() != null) {
            for (VtlParser.ComponentIDContext usingContext : joinClauseContext.componentID()) {
                String name = usingContext.getText();
                for (DatasetExpression datasetExpression : datasets.values()) {
                    List names = datasetExpression.getColumnNames();
                    if (!names.contains(name)) {
                        throw new VtlRuntimeException(new InvalidArgumentException("using component " + name + " is not present in all datasets", VtlScriptEngine.fromContext((ParseTree)usingContext)));
                    }
                    if (((Structured.Component)datasetExpression.getDataStructure().get((Object)name)).isIdentifier()) continue;
                    throw new VtlRuntimeException(new InvalidArgumentException("using component " + name + " has to be an identifier", VtlScriptEngine.fromContext((ParseTree)usingContext)));
                }
                Structured.Component component = (Structured.Component)datasets.values().iterator().next().getDataStructure().values().stream().filter(c -> c.getName().equals(name)).collect(Collectors.toList()).get(0);
                commonIdentifiers.add(component);
            }
        }
        return commonIdentifiers;
    }
}

