/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression.functions;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.InvalidArgumentException;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.utils.TypeChecking;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.DatasetExpression;
import fr.insee.vtl.model.ProcessingEngine;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class SetFunctionsVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private final ExpressionVisitor expressionVisitor;
    private final ProcessingEngine processingEngine;

    public SetFunctionsVisitor(ExpressionVisitor expressionVisitor, ProcessingEngine processingEngine) {
        this.expressionVisitor = Objects.requireNonNull(expressionVisitor);
        this.processingEngine = Objects.requireNonNull(processingEngine);
    }

    public ResolvableExpression visitUnionAtom(VtlParser.UnionAtomContext ctx) {
        ArrayList<DatasetExpression> datasets = new ArrayList<DatasetExpression>();
        Structured.DataStructure structure = null;
        for (VtlParser.ExprContext expr : ctx.expr()) {
            DatasetExpression rest = (DatasetExpression)TypeChecking.assertTypeExpression((ResolvableExpression)this.expressionVisitor.visit((ParseTree)expr), Dataset.class, (ParseTree)expr);
            datasets.add(rest);
            if (structure == null) {
                structure = rest.getDataStructure();
                continue;
            }
            if (structure.equals((Object)rest.getDataStructure())) continue;
            throw new VtlRuntimeException(new InvalidArgumentException(String.format("dataset structure of %s is incompatible with %s", expr.getText(), ctx.expr().stream().map(RuleContext::getText).collect(Collectors.joining(", "))), VtlScriptEngine.fromContext((ParseTree)ctx)));
        }
        return this.processingEngine.executeUnion(datasets);
    }
}

