/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression.functions;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.InvalidArgumentException;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.expressions.ComponentExpression;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.model.Analytics;
import fr.insee.vtl.model.ConstantExpression;
import fr.insee.vtl.model.DatasetExpression;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ProcessingEngine;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.model.utils.Java8Helpers;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.threeten.extra.Interval;

public class TimeFunctionsVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private final GenericFunctionsVisitor genericFunctionsVisitor;
    private final ExpressionVisitor expressionVisitor;
    private final ProcessingEngine processingEngine;

    public TimeFunctionsVisitor(GenericFunctionsVisitor genericFunctionsVisitor, ExpressionVisitor expressionVisitor, ProcessingEngine processingEngine) {
        this.genericFunctionsVisitor = genericFunctionsVisitor;
        this.expressionVisitor = expressionVisitor;
        this.processingEngine = processingEngine;
    }

    public ResolvableExpression visitCurrentDateAtom(VtlParser.CurrentDateAtomContext ctx) {
        return new ConstantExpression((Object)Instant.now(), VtlScriptEngine.fromContext((ParseTree)ctx));
    }

    public ResolvableExpression visitFlowAtom(VtlParser.FlowAtomContext ctx) {
        if (ctx.FLOW_TO_STOCK() != null) {
            return this.flowToStock(ctx);
        }
        if (ctx.STOCK_TO_FLOW() != null) {
            return this.stockToFlows(ctx);
        }
        throw new UnsupportedOperationException("unknown op token " + ctx.op);
    }

    private ResolvableExpression stockToFlows(VtlParser.FlowAtomContext ctx) {
        VtlParser.ExprContext expr = ctx.expr();
        ResolvableExpression operand = (ResolvableExpression)this.expressionVisitor.visit((ParseTree)expr);
        try {
            Positioned position = VtlScriptEngine.fromContext((ParseTree)ctx);
            if (!(operand instanceof DatasetExpression)) {
                throw new InvalidArgumentException("flow to stock only supports datasets", position);
            }
            DatasetExpression ds = (DatasetExpression)operand;
            LinkedHashMap ids = ds.getIdentifiers().stream().collect(Collectors.toMap(Structured.Component::getName, c -> Analytics.Order.ASC, (a, b) -> b, LinkedHashMap::new));
            Structured.Component time = TimeFunctionsVisitor.extractTimeComponent((ParseTree)ctx, ds);
            List partition = ids.keySet().stream().filter(colName -> !time.getName().equals(colName)).collect(Collectors.toList());
            for (Structured.Component measure : ds.getMeasures()) {
                if (!Number.class.isAssignableFrom(measure.getType())) continue;
                String measureName = measure.getName();
                String lagColumnName = measure.getName() + "_lag";
                DatasetExpression lag = this.processingEngine.executeLeadOrLagAn(ds, measureName, Analytics.Function.LAG, measureName, 1, partition, (Map)ids);
                lag = this.processingEngine.executeRename(lag, Java8Helpers.mapOf((Object)measureName, (Object)lagColumnName));
                lag = this.processingEngine.executeProject(lag, Stream.concat(ds.getIdentifiers().stream().map(Structured.Component::getName), Stream.of(lagColumnName)).collect(Collectors.toList()));
                ds = this.processingEngine.executeLeftJoin(Java8Helpers.mapOf((Object)"left", (Object)ds, (Object)"lag", (Object)lag), ds.getIdentifiers());
                ComponentExpression measureExpr = new ComponentExpression((Structured.Component)ds.getDataStructure().get((Object)measure.getName()), position);
                ComponentExpression lagExpr = new ComponentExpression((Structured.Component)ds.getDataStructure().get((Object)lagColumnName), position);
                ResolvableExpression nvlExpr = this.genericFunctionsVisitor.invokeFunction("nvl", Java8Helpers.listOf((Object[])new ResolvableExpression[]{lagExpr, new ConstantExpression((Object)0L, position)}), position);
                ResolvableExpression subtractionExpr = this.genericFunctionsVisitor.invokeFunction("subtraction", Java8Helpers.listOf((Object[])new ResolvableExpression[]{measureExpr, nvlExpr}), position);
                ds = this.processingEngine.executeCalc(ds, Java8Helpers.mapOf((Object)measure.getName(), (Object)subtractionExpr), Java8Helpers.mapOf(), Java8Helpers.mapOf());
                ds = this.processingEngine.executeProject(ds, ds.getColumnNames().stream().filter(s -> !s.equals(lagColumnName)).collect(Collectors.toList()));
            }
            return ds;
        }
        catch (VtlScriptException iae) {
            throw new VtlRuntimeException(iae);
        }
    }

    private ResolvableExpression flowToStock(VtlParser.FlowAtomContext ctx) {
        VtlParser.ExprContext expr = ctx.expr();
        ResolvableExpression operand = (ResolvableExpression)this.expressionVisitor.visit((ParseTree)expr);
        try {
            Positioned position = VtlScriptEngine.fromContext((ParseTree)ctx);
            if (!(operand instanceof DatasetExpression)) {
                throw new InvalidArgumentException("flow to stock only supports datasets", position);
            }
            DatasetExpression ds = (DatasetExpression)operand;
            LinkedHashMap ids = ds.getIdentifiers().stream().collect(Collectors.toMap(Structured.Component::getName, c -> Analytics.Order.ASC, (a, b) -> b, LinkedHashMap::new));
            Structured.Component time = TimeFunctionsVisitor.extractTimeComponent((ParseTree)ctx, ds);
            List partition = ids.keySet().stream().filter(colName -> !time.getName().equals(colName)).collect(Collectors.toList());
            for (Structured.Component measure : ds.getMeasures()) {
                ds = this.processingEngine.executeSimpleAnalytic(ds, measure.getName(), Analytics.Function.SUM, measure.getName(), partition, (Map)ids, null);
            }
            return ds;
        }
        catch (VtlScriptException iae) {
            throw new VtlRuntimeException(iae);
        }
    }

    public ResolvableExpression visitTimeShiftAtom(VtlParser.TimeShiftAtomContext ctx) {
        try {
            ResolvableExpression operand = (ResolvableExpression)this.expressionVisitor.visit((ParseTree)ctx.expr());
            ConstantExpression n = new ConstantExpression((Object)Long.parseLong(ctx.signedInteger().getText()), VtlScriptEngine.fromContext((ParseTree)ctx.signedInteger()));
            if (!(operand instanceof DatasetExpression)) {
                return this.genericFunctionsVisitor.invokeFunction("timeshift", Java8Helpers.listOf((Object[])new ResolvableExpression[]{operand, n}), VtlScriptEngine.fromContext((ParseTree)ctx));
            }
            DatasetExpression ds = (DatasetExpression)operand;
            Structured.Component t = TimeFunctionsVisitor.extractTimeComponent((ParseTree)ctx, ds);
            ResolvableExpression compExpr = this.genericFunctionsVisitor.invokeFunction("timeshift", Java8Helpers.listOf((Object[])new ResolvableExpression[]{new ComponentExpression(t, VtlScriptEngine.fromContext((ParseTree)ctx)), n}), VtlScriptEngine.fromContext((ParseTree)ctx));
            return this.processingEngine.executeCalc(ds, Java8Helpers.mapOf((Object)t.getName(), (Object)compExpr), Java8Helpers.mapOf((Object)t.getName(), (Object)t.getRole()), Java8Helpers.mapOf());
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    private static Structured.Component extractTimeComponent(ParseTree ctx, DatasetExpression ds) throws InvalidArgumentException {
        Structured.Component t = ds.getIdentifiers().stream().filter(component -> component.getType().equals(Interval.class) || component.getType().equals(Instant.class) || component.getType().equals(ZonedDateTime.class) || component.getType().equals(OffsetDateTime.class)).findFirst().orElseThrow(() -> new InvalidArgumentException("no time column in " + ctx.getText(), VtlScriptEngine.fromContext(ctx)));
        return t;
    }
}

