/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import fr.insee.vtl.model.Dataset;
import java.io.IOException;
import javax.script.Bindings;
import javax.script.SimpleBindings;

public class BindingsDeserializer
extends StdDeserializer<Bindings> {
    protected BindingsDeserializer() {
        super(Bindings.class);
    }

    public Bindings deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        SimpleBindings bindings = new SimpleBindings();
        JsonToken token = p.currentToken();
        if (!token.isStructStart()) {
            ctxt.handleUnexpectedToken(Bindings.class, p);
        }
        while (p.nextToken() == JsonToken.FIELD_NAME) {
            String name = p.currentName();
            JsonToken value = p.nextValue();
            if (value.isStructStart()) {
                bindings.put(name, ctxt.readValue(p, Dataset.class));
                continue;
            }
            bindings.put(name, ctxt.readValue(p, Object.class));
        }
        return bindings;
    }
}

