/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import fr.insee.vtl.model.Structured;
import java.io.IOException;
import java.util.Map;

public class ComponentSerializer
extends StdSerializer<Structured.Component> {
    private static final Map<Class<?>, String> TYPES = Map.of(String.class, "STRING", Long.class, "INTEGER", Double.class, "NUMBER", Boolean.class, "BOOLEAN");

    protected ComponentSerializer() {
        super(Structured.Component.class);
    }

    public void serialize(Structured.Component value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeObjectField("name", (Object)value.getName());
        gen.writeObjectField("type", (Object)TYPES.get(value.getType()));
        gen.writeObjectField("role", (Object)value.getRole());
        gen.writeObjectField("nullable", (Object)value.getNullable());
        gen.writeEndObject();
    }
}

