/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.model.utils.Java8Helpers;
import java.io.IOException;
import java.util.Map;

public class ComponentDeserializer
extends StdDeserializer<Structured.Component> {
    private static final Map<String, Class<?>> TYPES = Java8Helpers.mapOf((Object)"STRING", String.class, (Object)"INTEGER", Long.class, (Object)"NUMBER", Double.class, (Object)"BOOLEAN", Boolean.class);

    protected ComponentDeserializer() {
        super(Structured.Component.class);
    }

    public Structured.Component deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = ctxt.readTree(p);
        String name = node.get("name").asText();
        String type = node.get("type").asText();
        Dataset.Role role = Dataset.Role.valueOf((String)node.get("role").asText());
        Boolean nullable = node.get("nullable") != null ? Boolean.valueOf(node.get("nullable").asBoolean()) : null;
        return new Structured.Component(name, this.asType(type), role, nullable);
    }

    private Class<?> asType(String type) {
        return TYPES.get(type);
    }
}

