/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.InMemoryDataset;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.model.utils.Java8Helpers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DatasetDeserializer
extends StdDeserializer<Dataset> {
    private static final Set<String> STRUCTURE_NAMES = Java8Helpers.setOf((Object[])new String[]{"structure", "dataStructure"});
    private static final Set<String> DATAPOINT_NAMES = Java8Helpers.setOf((Object[])new String[]{"data", "dataPoints"});

    protected DatasetDeserializer() {
        super(Dataset.class);
    }

    public Dataset deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.currentToken() != JsonToken.START_OBJECT) {
            ctxt.handleUnexpectedToken(Dataset.class, p);
        }
        List<Structured.Component> structure = null;
        List<List<Object>> dataPoints = null;
        while (p.nextToken() != JsonToken.END_OBJECT) {
            if (STRUCTURE_NAMES.contains(p.currentName())) {
                structure = this.deserializeStructure(p, ctxt);
                if (dataPoints == null) continue;
                this.convertDataPoints(p, dataPoints, structure);
                continue;
            }
            if (!DATAPOINT_NAMES.contains(p.currentName())) continue;
            if (structure != null) {
                dataPoints = this.deserializeDataPoints(p, ctxt, structure);
                continue;
            }
            dataPoints = this.deserializeUncheckedDataPoint(p, ctxt);
        }
        return new InMemoryDataset(dataPoints, structure);
    }

    private void convertDataPoints(JsonParser p, List<List<Object>> objects, List<Structured.Component> components) throws IOException {
        List deserializers = components.stream().map(PointDeserializer::new).collect(Collectors.toList());
        for (List<Object> object : objects) {
            for (int i = 0; i < object.size(); ++i) {
                Object converted = ((PointDeserializer)deserializers.get(i)).convert(p, object.get(i));
                object.set(i, converted);
            }
        }
    }

    private List<List<Object>> deserializeDataPoints(JsonParser p, DeserializationContext ctxt, List<Structured.Component> components) throws IOException {
        JsonToken token;
        String fieldName = p.currentName();
        if (!DATAPOINT_NAMES.contains(fieldName)) {
            ctxt.handleUnexpectedToken(Dataset.class, p);
        }
        if ((token = p.nextToken()) != JsonToken.START_ARRAY) {
            ctxt.handleUnexpectedToken(Dataset.class, p);
        }
        List deserializers = components.stream().map(PointDeserializer::new).collect(Collectors.toList());
        ArrayList<List<Object>> dataPoints = new ArrayList<List<Object>>();
        while (p.nextToken() == JsonToken.START_ARRAY) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (PointDeserializer deserializer : deserializers) {
                p.nextValue();
                row.add(deserializer.deserialize(p, ctxt));
            }
            if (p.nextToken() != JsonToken.END_ARRAY) {
                ctxt.handleUnexpectedToken(Dataset.class, p);
            }
            dataPoints.add(row);
        }
        return dataPoints;
    }

    private List<List<Object>> deserializeUncheckedDataPoint(JsonParser p, DeserializationContext ctxt) throws IOException {
        String fieldName = p.currentName();
        if (!DATAPOINT_NAMES.contains(fieldName)) {
            ctxt.handleUnexpectedToken(Dataset.class, p);
        }
        p.nextToken();
        CollectionLikeType listOfComponentType = ctxt.getTypeFactory().constructCollectionLikeType(List.class, List.class);
        return (List)ctxt.readValue(p, (JavaType)listOfComponentType);
    }

    private List<Structured.Component> deserializeStructure(JsonParser p, DeserializationContext ctxt) throws IOException {
        String fieldName = p.currentName();
        if (!STRUCTURE_NAMES.contains(fieldName)) {
            ctxt.handleUnexpectedToken(Dataset.class, p);
        }
        p.nextToken();
        CollectionLikeType listOfComponentType = ctxt.getTypeFactory().constructCollectionLikeType(List.class, Structured.Component.class);
        return (List)ctxt.readValue(p, (JavaType)listOfComponentType);
    }

    private static class PointDeserializer {
        private final Structured.Component component;

        PointDeserializer(Structured.Component component) {
            this.component = Objects.requireNonNull(component);
        }

        Object convert(JsonParser p, Object object) throws IOException {
            return this.convert(p.getCodec(), object, this.component.getType());
        }

        Object convert(ObjectCodec codec, Object node, Class<?> type) throws IOException {
            TokenBuffer buf = new TokenBuffer(codec, false);
            codec.writeValue((JsonGenerator)buf, node);
            return buf.asParser().readValueAs(type);
        }

        Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                if (p.currentToken() == JsonToken.VALUE_NULL) {
                    return null;
                }
                return ctxt.readValue(p, this.component.getType());
            }
            catch (IOException ioe) {
                throw JsonMappingException.from((JsonParser)p, (String)String.format("failed to deserialize column %s", this.component.getName()), (Throwable)ioe);
            }
        }
    }
}

