/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.jdbc;

import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.Structured;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class JDBCDataset
implements Dataset {
    private final Supplier<ResultSet> resultSetSupplier;
    private Structured.DataStructure structure;

    public JDBCDataset(Supplier<ResultSet> resultSetSupplier) {
        this.resultSetSupplier = resultSetSupplier;
    }

    public static Class<?> toVtlType(Integer sqlType) {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return Long.class;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return Double.class;
            }
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case -16: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2002: 
            case 2005: 
            case 2006: 
            case 2009: {
                return String.class;
            }
        }
        throw new UnsupportedOperationException("unsupported type " + sqlType);
    }

    public static Structured.DataStructure toDataStructure(ResultSetMetaData metaData) throws SQLException {
        ArrayList<Structured.Component> components = new ArrayList<Structured.Component>();
        for (int columnIdx = 1; columnIdx <= metaData.getColumnCount(); ++columnIdx) {
            String name = metaData.getColumnName(columnIdx);
            Class<?> type = JDBCDataset.toVtlType(metaData.getColumnType(columnIdx));
            components.add(new Structured.Component(name, type, Dataset.Role.MEASURE, Boolean.valueOf(true)));
        }
        return new Structured.DataStructure(components);
    }

    public List<Structured.DataPoint> getDataPoints() {
        ArrayList<Structured.DataPoint> arrayList;
        block9: {
            ResultSet resultSet = this.resultSetSupplier.get();
            try {
                ArrayList<Structured.DataPoint> result = new ArrayList<Structured.DataPoint>();
                while (resultSet.next()) {
                    result.add(this.toDataPoint(resultSet));
                }
                arrayList = result;
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException se) {
                    throw new RuntimeException(se);
                }
            }
            resultSet.close();
        }
        return arrayList;
    }

    private Structured.DataPoint toDataPoint(ResultSet resultSet) {
        try {
            Structured.DataPoint point = new Structured.DataPoint(this.getDataStructure(resultSet));
            for (String column : this.structure.keySet()) {
                if (String.class.equals((Object)((Structured.Component)this.structure.get((Object)column)).getType())) {
                    point.set(column, (Object)resultSet.getString(column));
                    continue;
                }
                if (Long.class.equals((Object)((Structured.Component)this.structure.get((Object)column)).getType())) {
                    point.set(column, (Object)resultSet.getLong(column));
                    continue;
                }
                if (Double.class.equals((Object)((Structured.Component)this.structure.get((Object)column)).getType())) {
                    point.set(column, (Object)resultSet.getDouble(column));
                    continue;
                }
                if (Boolean.class.equals((Object)((Structured.Component)this.structure.get((Object)column)).getType())) {
                    point.set(column, (Object)resultSet.getBoolean(column));
                    continue;
                }
                throw new IllegalStateException("Unexpected value: " + ((Structured.Component)this.structure.get((Object)column)).getType());
            }
            return point;
        }
        catch (SQLException se) {
            throw new RuntimeException(se);
        }
    }

    private Structured.DataStructure getDataStructure(ResultSet resultSet) throws SQLException {
        if (this.structure == null) {
            this.structure = JDBCDataset.toDataStructure(resultSet.getMetaData());
        }
        return this.structure;
    }

    public Structured.DataStructure getDataStructure() {
        Structured.DataStructure dataStructure;
        block8: {
            ResultSet resultSet = this.resultSetSupplier.get();
            try {
                dataStructure = this.getDataStructure(resultSet);
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException se) {
                    throw new RuntimeException(se);
                }
            }
            resultSet.close();
        }
        return dataStructure;
    }
}

