/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.model;

import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.model.TypedExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class AggregationExpression
implements Collector<Structured.DataPoint, Object, Object>,
TypedExpression {
    private final Collector<Structured.DataPoint, ?, ?> aggregation;
    private final Class<?> type;

    public <T> AggregationExpression(Collector<Structured.DataPoint, ?, T> aggregation, Class<T> type) {
        this.aggregation = aggregation;
        this.type = type;
    }

    public <T> AggregationExpression(ResolvableExpression expression, Collector<Object, ?, T> collector, Class<T> type) {
        this(Collectors.mapping(expression::resolve, collector), type);
    }

    public static AggregationExpression count() {
        return new CountAggregationExpression(Collectors.counting(), Long.class);
    }

    public static AggregationExpression avg(ResolvableExpression expression) {
        if (Long.class.equals(expression.getType())) {
            return new AverageAggregationExpression(expression, Collectors.averagingLong(value -> (Long)value), Double.class);
        }
        if (Double.class.equals(expression.getType())) {
            return new AverageAggregationExpression(expression, Collectors.averagingDouble(value -> (Double)value), Double.class);
        }
        throw new Error("unexpected type");
    }

    public static AggregationExpression sum(ResolvableExpression expression) {
        if (Long.class.equals(expression.getType())) {
            return new SumAggregationExpression(expression, Collectors.summingLong(value -> (Long)value), Long.class);
        }
        if (Double.class.equals(expression.getType())) {
            return new SumAggregationExpression(expression, Collectors.summingDouble(value -> (Double)value), Double.class);
        }
        throw new Error("unexpected type");
    }

    public static AggregationExpression median(ResolvableExpression expression) {
        if (Long.class.equals(expression.getType())) {
            return new MedianAggregationExpression(expression, Collectors.mapping(v -> (Long)v, AggregationExpression.medianCollectorLong()), Double.class);
        }
        if (Double.class.equals(expression.getType())) {
            return new MedianAggregationExpression(expression, Collectors.mapping(v -> (Double)v, AggregationExpression.medianCollectorDouble()), Double.class);
        }
        throw new Error("unexpected type");
    }

    public static AggregationExpression max(ResolvableExpression expression) {
        if (Long.class.equals(expression.getType())) {
            Collector maxBy = Collectors.maxBy(Comparator.nullsFirst(Comparator.naturalOrder()));
            Collector mapping = Collectors.mapping(v -> (Long)v, maxBy);
            Collector<Object, ?, Long> res = Collectors.collectingAndThen(mapping, v -> v.orElse(null));
            return new MaxAggregationExpression(expression, res, Long.class);
        }
        if (Double.class.equals(expression.getType())) {
            Collector maxBy = Collectors.maxBy(Comparator.nullsFirst(Comparator.naturalOrder()));
            Collector mapping = Collectors.mapping(v -> (Double)v, maxBy);
            Collector<Object, ?, Double> res = Collectors.collectingAndThen(mapping, v -> v.orElse(null));
            return new MaxAggregationExpression(expression, res, Double.class);
        }
        throw new Error("unexpected type");
    }

    public static AggregationExpression min(ResolvableExpression expression) {
        if (Long.class.equals(expression.getType())) {
            Collector maxBy = Collectors.minBy(Comparator.nullsFirst(Comparator.naturalOrder()));
            Collector mapping = Collectors.mapping(v -> (Long)v, maxBy);
            Collector<Object, ?, Long> res = Collectors.collectingAndThen(mapping, v -> v.orElse(null));
            return new MinAggregationExpression(expression, res, Long.class);
        }
        if (Double.class.equals(expression.getType())) {
            Collector maxBy = Collectors.minBy(Comparator.nullsFirst(Comparator.naturalOrder()));
            Collector mapping = Collectors.mapping(v -> (Double)v, maxBy);
            Collector<Object, ?, Double> res = Collectors.collectingAndThen(mapping, v -> v.orElse(null));
            return new MinAggregationExpression(expression, res, Double.class);
        }
        throw new Error("unexpected type");
    }

    public static AggregationExpression stdDevPop(ResolvableExpression expression) {
        if (Long.class.equals(expression.getType())) {
            return new StdDevPopAggregationExpression(expression, Collectors.mapping(v -> (Long)v, AggregationExpression.stdDevPopCollectorLong()), Double.class);
        }
        if (Double.class.equals(expression.getType())) {
            return new StdDevPopAggregationExpression(expression, Collectors.mapping(v -> (Double)v, AggregationExpression.stdDevPopCollectorDouble()), Double.class);
        }
        throw new Error("unexpected type");
    }

    public static AggregationExpression stdDevSamp(ResolvableExpression expression) {
        if (Long.class.equals(expression.getType())) {
            return new StdDevSampAggregationExpression(expression, Collectors.mapping(v -> (Long)v, AggregationExpression.stdDevSampCollectorLong()), Double.class);
        }
        if (Double.class.equals(expression.getType())) {
            return new StdDevSampAggregationExpression(expression, Collectors.mapping(v -> (Double)v, AggregationExpression.stdDevSampCollectorDouble()), Double.class);
        }
        throw new Error("unexpected type");
    }

    public static AggregationExpression varPop(ResolvableExpression expression) {
        if (Long.class.equals(expression.getType())) {
            return new VarPopAggregationExpression(expression, Collectors.mapping(v -> (Long)v, AggregationExpression.varPopCollectorLong()), Double.class);
        }
        if (Double.class.equals(expression.getType())) {
            return new VarPopAggregationExpression(expression, Collectors.mapping(v -> (Double)v, AggregationExpression.varPopCollectorDouble()), Double.class);
        }
        throw new Error("unexpected type");
    }

    public static AggregationExpression varSamp(ResolvableExpression expression) {
        if (Long.class.equals(expression.getType())) {
            return new VarSampAggregationExpression(expression, Collectors.mapping(v -> (Long)v, AggregationExpression.varSampCollectorLong()), Double.class);
        }
        if (Double.class.equals(expression.getType())) {
            return new VarSampAggregationExpression(expression, Collectors.mapping(v -> (Double)v, AggregationExpression.varSampCollectorDouble()), Double.class);
        }
        throw new Error("unexpected type");
    }

    private static Collector<Long, List<Long>, Double> medianCollectorLong() {
        return Collector.of(ArrayList::new, List::add, (longs, longs2) -> {
            longs.addAll(longs2);
            return longs;
        }, (A longs) -> {
            if (longs.contains(null)) {
                return null;
            }
            Collections.sort(longs);
            if (longs.size() % 2 == 0) {
                return (double)((Long)longs.get(longs.size() / 2 - 1) + (Long)longs.get(longs.size() / 2)) / 2.0;
            }
            return (double)((Long)longs.get(longs.size() / 2));
        }, new Collector.Characteristics[0]);
    }

    private static Collector<Double, List<Double>, Double> medianCollectorDouble() {
        return Collector.of(ArrayList::new, List::add, (longs, longs2) -> {
            longs.addAll(longs2);
            return longs;
        }, (A longs) -> {
            if (longs.contains(null)) {
                return null;
            }
            Collections.sort(longs);
            if (longs.size() % 2 == 0) {
                return ((Double)longs.get(longs.size() / 2 - 1) + (Double)longs.get(longs.size() / 2)) / 2.0;
            }
            return (Double)longs.get(longs.size() / 2);
        }, new Collector.Characteristics[0]);
    }

    private static Collector<Long, List<Long>, Double> stdDevPopCollectorLong() {
        return Collector.of(ArrayList::new, List::add, (longs, longs2) -> {
            longs.addAll(longs2);
            return longs;
        }, AggregationExpression.getDeviationLongFn(true), new Collector.Characteristics[0]);
    }

    private static Collector<Double, List<Double>, Double> stdDevPopCollectorDouble() {
        return Collector.of(ArrayList::new, List::add, (longs, longs2) -> {
            longs.addAll(longs2);
            return longs;
        }, AggregationExpression.getDeviationDoubleFn(true), new Collector.Characteristics[0]);
    }

    private static Collector<Long, List<Long>, Double> stdDevSampCollectorLong() {
        return Collector.of(ArrayList::new, List::add, (longs, longs2) -> {
            longs.addAll(longs2);
            return longs;
        }, AggregationExpression.getDeviationLongFn(false), new Collector.Characteristics[0]);
    }

    private static Collector<Double, List<Double>, Double> stdDevSampCollectorDouble() {
        return Collector.of(ArrayList::new, List::add, (longs, longs2) -> {
            longs.addAll(longs2);
            return longs;
        }, AggregationExpression.getDeviationDoubleFn(false), new Collector.Characteristics[0]);
    }

    private static Collector<Long, List<Long>, Double> varPopCollectorLong() {
        return Collector.of(ArrayList::new, List::add, (longs, longs2) -> {
            longs.addAll(longs2);
            return longs;
        }, AggregationExpression.getVarLongFn(true), new Collector.Characteristics[0]);
    }

    private static Collector<Double, List<Double>, Double> varPopCollectorDouble() {
        return Collector.of(ArrayList::new, List::add, (longs, longs2) -> {
            longs.addAll(longs2);
            return longs;
        }, AggregationExpression.getVarDoubleFn(true), new Collector.Characteristics[0]);
    }

    private static Collector<Long, List<Long>, Double> varSampCollectorLong() {
        return Collector.of(ArrayList::new, List::add, (longs, longs2) -> {
            longs.addAll(longs2);
            return longs;
        }, AggregationExpression.getVarLongFn(false), new Collector.Characteristics[0]);
    }

    private static Collector<Double, List<Double>, Double> varSampCollectorDouble() {
        return Collector.of(ArrayList::new, List::add, (longs, longs2) -> {
            longs.addAll(longs2);
            return longs;
        }, AggregationExpression.getVarDoubleFn(false), new Collector.Characteristics[0]);
    }

    private static Function<List<Long>, Double> getDeviationLongFn(Boolean usePopulation) {
        return longs -> {
            if (longs.contains(null)) {
                return null;
            }
            if (longs.size() <= 1) {
                return 0.0;
            }
            Double avg = longs.stream().collect(Collectors.averagingLong(v -> v));
            return Math.sqrt(longs.stream().map(v -> Math.pow((double)v.longValue() - avg, 2.0)).mapToDouble(v -> v).sum() / ((double)longs.size() - (usePopulation != false ? 0.0 : 1.0)));
        };
    }

    private static Function<List<Double>, Double> getDeviationDoubleFn(Boolean usePopulation) {
        return doubles -> {
            if (doubles.contains(null)) {
                return null;
            }
            if (doubles.size() <= 1) {
                return 0.0;
            }
            Double avg = doubles.stream().collect(Collectors.averagingDouble(v -> v));
            return Math.sqrt(doubles.stream().map(v -> Math.pow(v - avg, 2.0)).mapToDouble(v -> v).sum() / ((double)doubles.size() - (usePopulation != false ? 0.0 : 1.0)));
        };
    }

    private static Function<List<Long>, Double> getVarLongFn(Boolean usePopulation) {
        return longs -> {
            if (longs.contains(null)) {
                return null;
            }
            if (longs.size() <= 1) {
                return 0.0;
            }
            Double avg = longs.stream().collect(Collectors.averagingLong(v -> v));
            return longs.stream().map(v -> Math.pow((double)v.longValue() - avg, 2.0)).mapToDouble(v -> v).sum() / ((double)longs.size() - (usePopulation != false ? 0.0 : 1.0));
        };
    }

    private static Function<List<Double>, Double> getVarDoubleFn(Boolean usePopulation) {
        return doubles -> {
            if (doubles.contains(null)) {
                return null;
            }
            if (doubles.size() <= 1) {
                return 0.0;
            }
            Double avg = doubles.stream().collect(Collectors.averagingDouble(v -> v));
            return doubles.stream().map(v -> Math.pow(v - avg, 2.0)).mapToDouble(v -> v).sum() / ((double)doubles.size() - (usePopulation != false ? 0.0 : 1.0));
        };
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Supplier<Object> supplier() {
        return this.aggregation.supplier();
    }

    @Override
    public BiConsumer<Object, Structured.DataPoint> accumulator() {
        return this.aggregation.accumulator();
    }

    @Override
    public BinaryOperator<Object> combiner() {
        return this.aggregation.combiner();
    }

    @Override
    public Function<Object, Object> finisher() {
        return this.aggregation.finisher();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return this.aggregation.characteristics();
    }

    public static class CountAggregationExpression
    extends AggregationExpression {
        private <T> CountAggregationExpression(Collector<Structured.DataPoint, ?, T> aggregation, Class<T> type) {
            super(aggregation, type);
        }
    }

    public static class AverageAggregationExpression
    extends AggregationExpression {
        public <T> AverageAggregationExpression(ResolvableExpression expression, Collector<Object, ?, T> collector, Class<T> type) {
            super(expression, collector, type);
        }
    }

    public static class SumAggregationExpression
    extends AggregationExpression {
        public <T> SumAggregationExpression(ResolvableExpression expression, Collector<Object, ?, T> collector, Class<T> type) {
            super(expression, collector, type);
        }
    }

    public static class MedianAggregationExpression
    extends AggregationExpression {
        public <T> MedianAggregationExpression(ResolvableExpression expression, Collector<Object, ?, T> collector, Class<T> type) {
            super(expression, collector, type);
        }
    }

    public static class MaxAggregationExpression
    extends AggregationExpression {
        public <T> MaxAggregationExpression(ResolvableExpression expression, Collector<Object, ?, T> collector, Class<T> type) {
            super(expression, collector, type);
        }
    }

    public static class MinAggregationExpression
    extends AggregationExpression {
        public <T> MinAggregationExpression(ResolvableExpression expression, Collector<Object, ?, T> collector, Class<T> type) {
            super(expression, collector, type);
        }
    }

    public static class StdDevPopAggregationExpression
    extends AggregationExpression {
        public <T> StdDevPopAggregationExpression(ResolvableExpression expression, Collector<Object, ?, T> collector, Class<T> type) {
            super(expression, collector, type);
        }
    }

    public static class StdDevSampAggregationExpression
    extends AggregationExpression {
        public <T> StdDevSampAggregationExpression(ResolvableExpression expression, Collector<Object, ?, T> collector, Class<T> type) {
            super(expression, collector, type);
        }
    }

    public static class VarPopAggregationExpression
    extends AggregationExpression {
        public <T> VarPopAggregationExpression(ResolvableExpression expression, Collector<Object, ?, T> collector, Class<T> type) {
            super(expression, collector, type);
        }
    }

    public static class VarSampAggregationExpression
    extends AggregationExpression {
        public <T> VarSampAggregationExpression(ResolvableExpression expression, Collector<Object, ?, T> collector, Class<T> type) {
            super(expression, collector, type);
        }
    }
}

