/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.model;

import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import java.util.function.Function;

public class DataPointRule {
    private final String name;
    private final Function<Structured.DataStructure, ResolvableExpression> untypedAntecedentExpr;
    private final Function<Structured.DataStructure, ResolvableExpression> untypedConsequentExpr;
    private final ResolvableExpression errorCodeExpression;
    private final ResolvableExpression errorLevelExpression;

    public <T> DataPointRule(String name, Function<Structured.DataStructure, ResolvableExpression> untypedAntecedentExpr, Function<Structured.DataStructure, ResolvableExpression> untypedConsequentExpr, ResolvableExpression errorCodeExpression, ResolvableExpression errorLevelExpression) {
        this.name = name;
        this.untypedAntecedentExpr = untypedAntecedentExpr;
        this.untypedConsequentExpr = untypedConsequentExpr;
        this.errorCodeExpression = errorCodeExpression;
        this.errorLevelExpression = errorLevelExpression;
    }

    public String getName() {
        return this.name;
    }

    public ResolvableExpression getBuildAntecedentExpression(Structured.DataStructure dataStructure) {
        return this.untypedAntecedentExpr.apply(dataStructure);
    }

    public ResolvableExpression getBuildConsequentExpression(Structured.DataStructure dataStructure) {
        return this.untypedConsequentExpr.apply(dataStructure);
    }

    public ResolvableExpression getErrorCodeExpression() {
        return this.errorCodeExpression;
    }

    public ResolvableExpression getErrorLevelExpression() {
        return this.errorLevelExpression;
    }
}

