/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.model;

import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.Structured;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class InMemoryDataset
implements Dataset {
    private final List<Structured.DataPoint> data;
    private final Structured.DataStructure structure;

    public InMemoryDataset(List<Structured.DataPoint> data, Map<String, Structured.Component> structure) {
        this.structure = new Structured.DataStructure(structure.values());
        this.data = data;
    }

    public InMemoryDataset(List<Map<String, Object>> data, Map<String, Class<?>> types, Map<String, Dataset.Role> roles) {
        if (!Objects.requireNonNull(types).keySet().equals(Objects.requireNonNull(roles).keySet())) {
            throw new IllegalArgumentException("types and role keys differ");
        }
        this.structure = new Structured.DataStructure(types, roles);
        this.data = this.convert(data);
    }

    public InMemoryDataset(List<Map<String, Object>> data, Map<String, Class<?>> types, Map<String, Dataset.Role> roles, Map<String, Boolean> nullables) {
        if (!Objects.requireNonNull(types).keySet().equals(Objects.requireNonNull(roles).keySet())) {
            throw new IllegalArgumentException("types and role keys differ");
        }
        this.structure = new Structured.DataStructure(types, roles, nullables);
        this.data = this.convert(data);
    }

    public InMemoryDataset(Structured.DataStructure structures, List<Object> ... data) {
        this.structure = structures;
        this.data = this.convertList(List.of(data));
    }

    public InMemoryDataset(List<Structured.Component> structure, List<Object> ... dataPoints) {
        this(List.of(dataPoints), structure);
    }

    public InMemoryDataset(List<List<Object>> data, List<Structured.Component> structures) {
        this.structure = new Structured.DataStructure(structures);
        this.data = this.convertList(data);
    }

    public InMemoryDataset(List<List<Object>> data, Structured.DataStructure structures) {
        this.structure = structures;
        this.data = this.convertList(data);
    }

    private List<Structured.DataPoint> convert(List<Map<String, Object>> data) {
        return Objects.requireNonNull(data).stream().map(map -> new Structured.DataPoint(this.structure, (Map<String, Object>)map)).collect(Collectors.toList());
    }

    private List<Structured.DataPoint> convertList(List<List<Object>> data) {
        return Objects.requireNonNull(data).stream().map(map -> new Structured.DataPoint(this.structure, (Collection<Object>)map)).collect(Collectors.toList());
    }

    @Override
    public List<Structured.DataPoint> getDataPoints() {
        return this.data;
    }

    @Override
    public Structured.DataStructure getDataStructure() {
        return this.structure;
    }
}

