/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.model;

import fr.insee.vtl.model.AggregationExpression;
import fr.insee.vtl.model.Analytics;
import fr.insee.vtl.model.DataPointRuleset;
import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.DatasetExpression;
import fr.insee.vtl.model.HierarchicalRuleset;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface ProcessingEngine {
    public DatasetExpression executeCalc(DatasetExpression var1, Map<String, ResolvableExpression> var2, Map<String, Dataset.Role> var3, Map<String, String> var4);

    public DatasetExpression executeFilter(DatasetExpression var1, ResolvableExpression var2, String var3);

    public DatasetExpression executeRename(DatasetExpression var1, Map<String, String> var2);

    public DatasetExpression executeProject(DatasetExpression var1, List<String> var2);

    public DatasetExpression executeUnion(List<DatasetExpression> var1);

    public DatasetExpression executeAggr(DatasetExpression var1, List<String> var2, Map<String, AggregationExpression> var3);

    public DatasetExpression executeSimpleAnalytic(DatasetExpression var1, String var2, Analytics.Function var3, String var4, List<String> var5, Map<String, Analytics.Order> var6, Analytics.WindowSpec var7);

    public DatasetExpression executeLeadOrLagAn(DatasetExpression var1, String var2, Analytics.Function var3, String var4, int var5, List<String> var6, Map<String, Analytics.Order> var7);

    public DatasetExpression executeRatioToReportAn(DatasetExpression var1, String var2, Analytics.Function var3, String var4, List<String> var5);

    public DatasetExpression executeRankAn(DatasetExpression var1, String var2, Analytics.Function var3, List<String> var4, Map<String, Analytics.Order> var5);

    public DatasetExpression executeLeftJoin(Map<String, DatasetExpression> var1, List<Structured.Component> var2);

    public DatasetExpression executeInnerJoin(Map<String, DatasetExpression> var1, List<Structured.Component> var2);

    default public DatasetExpression executeInnerJoin(Map<String, DatasetExpression> datasets) {
        Set commonIdentifiers = datasets.values().stream().flatMap(datasetExpression -> datasetExpression.getDataStructure().values().stream()).filter(Structured.Component::isIdentifier).collect(Collectors.toSet());
        return this.executeInnerJoin(datasets, new ArrayList<Structured.Component>(commonIdentifiers));
    }

    public DatasetExpression executeCrossJoin(Map<String, DatasetExpression> var1, List<Structured.Component> var2);

    public DatasetExpression executeFullJoin(Map<String, DatasetExpression> var1, List<Structured.Component> var2);

    public DatasetExpression executeValidateDPruleset(DataPointRuleset var1, DatasetExpression var2, String var3, Positioned var4);

    public DatasetExpression executeValidationSimple(DatasetExpression var1, ResolvableExpression var2, ResolvableExpression var3, DatasetExpression var4, String var5, Positioned var6);

    public ResolvableExpression executeHierarchicalValidation(DatasetExpression var1, HierarchicalRuleset var2, String var3, String var4, String var5, String var6, Positioned var7);
}

