/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.model;

import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.model.TypedExpression;
import fr.insee.vtl.model.VtlFunction;
import fr.insee.vtl.model.exceptions.InvalidTypeException;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public abstract class ResolvableExpression
implements TypedExpression,
Positioned,
Serializable {
    private final Positioned.Position position;

    protected ResolvableExpression(Positioned positioned) {
        this(Objects.requireNonNull(positioned).getPosition());
    }

    protected ResolvableExpression(Positioned.Position position) {
        this.position = Objects.requireNonNull(position);
    }

    public static <T> Builder<T> withType(Class<T> type) {
        return new Builder<T>(type);
    }

    @Override
    public Positioned.Position getPosition() {
        return this.position;
    }

    public ResolvableExpression checkInstanceOf(Class<?> clazz) throws InvalidTypeException {
        if (Object.class.equals(this.getType())) {
            return ResolvableExpression.withType(Object.class).withPosition(this).using(ctx -> null);
        }
        if (!clazz.isAssignableFrom(this.getType())) {
            throw new InvalidTypeException(clazz, this.getType(), (Positioned)this);
        }
        return this;
    }

    public <T> ResolvableExpression tryCast(Class<T> clazz) {
        if (Object.class.equals(this.getType())) {
            return ResolvableExpression.withType(clazz).withPosition(this).using(ctx -> null);
        }
        return ResolvableExpression.withType(clazz).withPosition(this).using(ctx -> {
            Object value = this.resolve((Map<String, Object>)ctx);
            try {
                return clazz.cast(value);
            }
            catch (ClassCastException cce) {
                throw new RuntimeException(new VtlScriptException(cce, (Positioned)this));
            }
        });
    }

    public abstract Object resolve(Map<String, Object> var1);

    public Object resolve(Structured.DataPoint context) {
        return this.resolve(new Structured.DataPointMap(context));
    }

    public static class Builder<T>
    implements Serializable {
        private final Class<T> type;
        private Positioned.Position position;

        Builder(Class<T> type) {
            this.type = type;
        }

        public Builder<T> withPosition(Positioned positioned) {
            return this.withPosition(positioned.getPosition());
        }

        public Builder<T> withPosition(Positioned.Position position) {
            this.position = position;
            return this;
        }

        public ResolvableExpression using(final VtlFunction<Map<String, Object>, T> function) {
            return new ResolvableExpression(this.position){

                @Override
                public Object resolve(Map<String, Object> context) {
                    return function.apply(context);
                }

                @Override
                public Class<?> getType() {
                    return type;
                }
            };
        }
    }
}

