/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.model.exceptions;

import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import java.util.Set;
import java.util.stream.Collectors;

public class InvalidTypeException
extends VtlScriptException {
    private final Class<?> expectedType;
    private final Set<Class<?>> expectedTypes;
    private final Class<?> receivedType;

    public InvalidTypeException(Class<?> expectedType, Class<?> receivedType, Positioned position) {
        super(String.format("invalid type %s, expected %s", receivedType.getSimpleName(), expectedType.getSimpleName()), position);
        this.expectedType = expectedType;
        this.expectedTypes = Set.of(expectedType);
        this.receivedType = receivedType;
    }

    public InvalidTypeException(Set<Class<?>> expectedTypes, Class<?> receivedType, Positioned position) {
        super(String.format("invalid type %s to be %s", receivedType.getSimpleName(), expectedTypes.stream().map(Class::getSimpleName).sorted().collect(Collectors.joining(" or "))), position);
        this.expectedType = null;
        this.expectedTypes = expectedTypes;
        this.receivedType = receivedType;
    }

    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    public Set<Class<?>> getExpectedTypes() {
        return this.expectedTypes;
    }

    public Class<?> getReceivedType() {
        return this.receivedType;
    }
}

