/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class IndexedHashMap<K, V>
implements Map<K, V> {
    private final Map<K, Integer> indices;
    private final Map<K, V> delegate;

    public IndexedHashMap() {
        this.indices = new HashMap<K, Integer>();
        this.delegate = new LinkedHashMap();
    }

    public IndexedHashMap(int initialCapacity) {
        this.indices = new HashMap<K, Integer>(initialCapacity);
        this.delegate = new LinkedHashMap(initialCapacity);
    }

    public IndexedHashMap(IndexedHashMap<K, V> map) {
        this.indices = new HashMap<K, Integer>(map.indices);
        this.delegate = new LinkedHashMap<K, V>(map.delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    public int indexOfKey(K key) {
        return this.indices.getOrDefault(key, -1);
    }

    public int indexOfValue(V value) {
        if (value == null) {
            for (Map.Entry<K, V> e : this.entrySet()) {
                if (e.getValue() != null) continue;
                return this.indexOfKey(e.getKey());
            }
        } else {
            for (Map.Entry<K, V> e : this.entrySet()) {
                if (!value.equals(e.getValue())) continue;
                return this.indexOfKey(e.getKey());
            }
        }
        return -1;
    }

    @Override
    public synchronized V put(K key, V value) {
        Integer index = this.delegate.containsKey(key) ? this.indices.get(key) : this.indices.values().stream().max(Integer::compareTo).orElse(-1) + 1;
        this.indices.put(key, index);
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.indices.remove(key);
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.indices.clear();
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedHashMap that = (IndexedHashMap)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }
}

