/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.model;

import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.IndexedHashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public interface Structured {
    public DataStructure getDataStructure();

    default public List<String> getColumnNames() {
        return new ArrayList<String>(this.getDataStructure().keySet());
    }

    default public Map<String, Dataset.Role> getRoles() {
        return this.getDataStructure().values().stream().collect(Collectors.toMap(Component::getName, Component::getRole));
    }

    default public List<Component> getIdentifiers() {
        return this.getDataStructure().getIdentifiers();
    }

    default public List<Component> getMeasures() {
        return this.getDataStructure().getMeasures();
    }

    default public List<Component> getAttributes() {
        return this.getDataStructure().getAttributes();
    }

    default public Boolean isMonoMeasure() {
        return this.getDataStructure().isMonoMeasure();
    }

    public static class DataPointMap
    implements Map<String, Object> {
        private final DataPoint dataPoint;

        public DataPointMap(DataPoint dataPoint) {
            this.dataPoint = dataPoint;
        }

        @Override
        public int size() {
            return this.dataPoint.size();
        }

        @Override
        public boolean isEmpty() {
            return this.dataPoint.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.dataPoint.dataStructure.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.dataPoint.contains(value);
        }

        @Override
        public Object get(Object key) {
            return this.dataPoint.get((String)key);
        }

        @Override
        public Object put(String key, Object value) {
            return this.dataPoint.set(key, value);
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            return this.dataPoint.dataStructure.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.dataPoint;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.dataPoint.dataStructure.keySet().stream().map(component -> new AbstractMap.SimpleEntry<String, Object>((String)component, this.dataPoint.get((String)component))).collect(Collectors.toSet());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map)) {
                return false;
            }
            Map that = (Map)o;
            return this.entrySet().equals(that.entrySet());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.entrySet());
        }

        public String toString() {
            Iterator<Map.Entry<String, Object>> i = this.entrySet().iterator();
            if (!i.hasNext()) {
                return "{}";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            while (true) {
                Map.Entry<String, Object> e = i.next();
                String key = e.getKey();
                Object value = e.getValue();
                sb.append(key);
                sb.append('=');
                sb.append(value == this ? "(this Map)" : value);
                if (!i.hasNext()) {
                    return sb.append('}').toString();
                }
                sb.append(',').append(' ');
            }
        }
    }

    public static class DataPoint
    extends ArrayList<Object> {
        private final DataStructure dataStructure;

        public DataPoint(DataStructure dataStructure, Map<String, Object> map) {
            this.growSize(dataStructure.size());
            this.dataStructure = Objects.requireNonNull(dataStructure);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }

        public DataPoint(DataStructure dataStructure) {
            this.growSize(dataStructure.size());
            this.dataStructure = Objects.requireNonNull(dataStructure);
        }

        public DataPoint(DataStructure dataStructure, Collection<Object> collection) {
            super(dataStructure.size());
            this.dataStructure = Objects.requireNonNull(dataStructure);
            this.addAll(collection);
        }

        private void growSize(int size) {
            while (this.size() < size) {
                this.add(null);
            }
        }

        public Object get(String column) {
            return this.get(this.dataStructure.indexOfKey(column));
        }

        public Object set(String column, Object object) {
            int index = this.dataStructure.indexOfKey(column);
            if (index > this.size() - 1) {
                this.growSize(index + 1);
            }
            return this.set(index, object);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataPoint objects = (DataPoint)o;
            for (Component component : this.dataStructure.values()) {
                if (!Dataset.Role.IDENTIFIER.equals((Object)component.getRole()) || this.get(component.getName()).equals(objects.get(component.getName()))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (Component component : this.dataStructure.values()) {
                if (!Dataset.Role.IDENTIFIER.equals((Object)component.getRole())) continue;
                Object e = this.get(component.getName());
                hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
            }
            return hashCode;
        }
    }

    public static class DataStructure
    extends IndexedHashMap<String, Component> {
        public DataStructure(Map<String, Class<?>> types, Map<String, Dataset.Role> roles) {
            super(types.size());
            if (!types.keySet().equals(roles.keySet())) {
                throw new IllegalArgumentException("type and roles key sets inconsistent");
            }
            for (String column : types.keySet()) {
                Component component = new Component(column, types.get(column), roles.get(column));
                this.put(column, component);
            }
        }

        public DataStructure(Map<String, Class<?>> types, Map<String, Dataset.Role> roles, Map<String, Boolean> nullables) {
            super(types.size());
            if (!types.keySet().equals(roles.keySet())) {
                throw new IllegalArgumentException("type and roles key sets inconsistent");
            }
            for (String column : types.keySet()) {
                Component component = new Component(column, types.get(column), roles.get(column), nullables.get(column));
                this.put(column, component);
            }
        }

        public DataStructure(Collection<Component> components) {
            super(components.size());
            HashSet<Component> duplicates = new HashSet<Component>();
            for (Component component : components) {
                Component newComponent = new Component(component);
                Component old = this.put(newComponent.getName(), newComponent);
                if (old == null) continue;
                duplicates.add(old);
            }
            if (!duplicates.isEmpty()) {
                throw new IllegalArgumentException("duplicate column " + duplicates);
            }
        }

        public DataStructure(DataStructure dataStructure) {
            super(dataStructure);
        }

        public List<Component> getIdentifiers() {
            return this.values().stream().filter(Component::isIdentifier).collect(Collectors.toList());
        }

        public List<Component> getMeasures() {
            return this.values().stream().filter(Component::isMeasure).collect(Collectors.toList());
        }

        public List<Component> getAttributes() {
            return this.values().stream().filter(Component::isAttribute).collect(Collectors.toList());
        }

        public Map<String, Dataset.Role> getRoles() {
            return this.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Component)e.getValue()).getRole()));
        }

        public List<Component> getByValuedomain(String valuedomain) {
            return this.values().stream().filter(c -> valuedomain.equals(c.getValuedomain())).collect(Collectors.toList());
        }

        public Boolean isMonoMeasure() {
            return this.getMeasures().size() == 1;
        }
    }

    public static class Component
    implements Serializable {
        private final String name;
        private final Class<?> type;
        private final Dataset.Role role;
        private final Boolean nullable;
        private final String valuedomain;

        public Component(String name, Class<?> type, Dataset.Role role) {
            this.name = Objects.requireNonNull(name);
            this.type = Objects.requireNonNull(type);
            this.role = Objects.requireNonNull(role);
            this.nullable = this.buildNullable(null, role);
            this.valuedomain = null;
        }

        public Component(String name, Class<?> type, Dataset.Role role, Boolean nullable, String valuedomain) {
            this.name = Objects.requireNonNull(name);
            this.type = Objects.requireNonNull(type);
            this.role = Objects.requireNonNull(role);
            this.nullable = this.buildNullable(nullable, role);
            this.valuedomain = valuedomain;
        }

        public Component(String name, Class<?> type, Dataset.Role role, Boolean nullable) {
            this.name = Objects.requireNonNull(name);
            this.type = Objects.requireNonNull(type);
            this.role = Objects.requireNonNull(role);
            this.nullable = this.buildNullable(nullable, role);
            this.valuedomain = null;
        }

        public Component(Component component) {
            this.name = component.getName();
            this.type = component.getType();
            this.role = component.getRole();
            this.nullable = component.getNullable();
            this.valuedomain = component.getValuedomain();
        }

        private Boolean buildNullable(Boolean initialNullable, Dataset.Role role) {
            if (role.equals((Object)Dataset.Role.IDENTIFIER)) {
                return false;
            }
            if (initialNullable == null) {
                return true;
            }
            return initialNullable;
        }

        public boolean isIdentifier() {
            return Dataset.Role.IDENTIFIER.equals((Object)this.role);
        }

        public boolean isMeasure() {
            return Dataset.Role.MEASURE.equals((Object)this.role);
        }

        public boolean isAttribute() {
            return Dataset.Role.ATTRIBUTE.equals((Object)this.role);
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Dataset.Role getRole() {
            return this.role;
        }

        public Boolean getNullable() {
            return this.nullable;
        }

        public String getValuedomain() {
            return this.valuedomain;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Component component = (Component)o;
            return this.name.equals(component.name) && this.type.equals(component.type) && this.role == component.role;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.type, this.role});
        }

        public String toString() {
            return "Component{" + this.name + ", type=" + this.type + ", role=" + (Object)((Object)this.role) + '}';
        }
    }
}

