/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.prov;

import fr.insee.vtl.parser.VtlBaseListener;
import fr.insee.vtl.parser.VtlLexer;
import fr.insee.vtl.parser.VtlParser;
import fr.insee.vtl.prov.prov.DataframeInstance;
import fr.insee.vtl.prov.prov.Program;
import fr.insee.vtl.prov.prov.ProgramStep;
import fr.insee.vtl.prov.prov.VariableInstance;
import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class ProvenanceListener
extends VtlBaseListener {
    private final Program program = new Program();
    private String currentProgramStep;
    private boolean isInDatasetClause;
    private String currentComponentID;

    public ProvenanceListener(String id, String programName) {
        this.program.setId(id);
        this.program.setLabel(programName);
    }

    private String getText(ParserRuleContext ctx) {
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        return start.getInputStream().getText(new Interval(start.getStartIndex(), stop.getStopIndex()));
    }

    public void enterStart(VtlParser.StartContext ctx) {
        this.program.setSourceCode(this.getText((ParserRuleContext)ctx));
    }

    public void enterTemporaryAssignment(VtlParser.TemporaryAssignmentContext ctx) {
        String id = this.getText((ParserRuleContext)ctx.varID());
        String sourceCode = this.getText((ParserRuleContext)ctx);
        this.currentProgramStep = id;
        ProgramStep programStep = new ProgramStep(id, id, sourceCode);
        DataframeInstance df = new DataframeInstance(id, id);
        programStep.setProducedDataframe(df);
        this.program.getProgramSteps().add(programStep);
    }

    public void exitTemporaryAssignment(VtlParser.TemporaryAssignmentContext ctx) {
        this.currentProgramStep = null;
    }

    public void enterPersistAssignment(VtlParser.PersistAssignmentContext ctx) {
        String id = this.getText((ParserRuleContext)ctx.varID());
        String sourceCode = this.getText((ParserRuleContext)ctx);
        this.currentProgramStep = id;
        ProgramStep programStep = new ProgramStep(id, id, sourceCode);
        DataframeInstance df = new DataframeInstance(id, id);
        programStep.setProducedDataframe(df);
        this.program.getProgramSteps().add(programStep);
    }

    public void exitPersistAssignment(VtlParser.PersistAssignmentContext ctx) {
        this.currentProgramStep = null;
    }

    public void enterVarID(VtlParser.VarIDContext ctx) {
        String id = ctx.IDENTIFIER().getText();
        if (!id.equals(this.currentProgramStep)) {
            ProgramStep programStep = this.program.getProgramStepById(this.currentProgramStep);
            if (!this.isInDatasetClause) {
                Set<DataframeInstance> consumedDataframe = programStep.getConsumedDataframe();
                DataframeInstance df = new DataframeInstance(id, id);
                consumedDataframe.add(df);
            }
            if (this.isInDatasetClause && null != this.currentComponentID) {
                Set<VariableInstance> usedVariables = programStep.getUsedVariables();
                VariableInstance v = new VariableInstance(id, id);
                usedVariables.add(v);
            }
        }
    }

    public void enterDatasetClause(VtlParser.DatasetClauseContext ctx) {
        this.isInDatasetClause = true;
    }

    public void exitDatasetClause(VtlParser.DatasetClauseContext ctx) {
        this.isInDatasetClause = false;
    }

    public void enterComponentID(VtlParser.ComponentIDContext ctx) {
        String id = ctx.getText();
        ProgramStep programStep = this.program.getProgramStepById(this.currentProgramStep);
        Set<VariableInstance> assignedVariables = programStep.getAssignedVariables();
        VariableInstance v = new VariableInstance(id, id);
        assignedVariables.add(v);
    }

    public void enterCalcClauseItem(VtlParser.CalcClauseItemContext ctx) {
        this.currentComponentID = this.getText((ParserRuleContext)ctx.componentID());
    }

    public void exitCalcClauseItem(VtlParser.CalcClauseItemContext ctx) {
        this.currentComponentID = null;
    }

    public void enterAggrFunctionClause(VtlParser.AggrFunctionClauseContext ctx) {
        this.currentComponentID = this.getText((ParserRuleContext)ctx.componentID());
    }

    public void exitAggrFunctionClause(VtlParser.AggrFunctionClauseContext ctx) {
        this.currentComponentID = null;
    }

    public Program getProgram() {
        return this.program;
    }

    public static Program run(String expr, String id, String programName) {
        CodePointCharStream stream = CharStreams.fromString((String)expr);
        VtlLexer lexer = new VtlLexer((CharStream)stream);
        VtlParser parser = new VtlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        ProvenanceListener provenanceListener = new ProvenanceListener(id, programName);
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)provenanceListener, (ParseTree)parser.start());
        return provenanceListener.getProgram();
    }
}

