/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.prov;

import fr.insee.vtl.prov.prov.DataframeInstance;
import fr.insee.vtl.prov.prov.Program;
import fr.insee.vtl.prov.prov.ProgramStep;
import fr.insee.vtl.prov.prov.VariableInstance;
import fr.insee.vtl.prov.utils.PROV;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class RDFUtils {
    private static final String TREVAS_BASE_URI = "http://trevas/";
    private static final String SDTH_BASE_URI = "http://rdf-vocabulary.ddialliance.org/sdth#";

    public static Model buildModel(Program program) {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prov", PROV.getURI());
        RDFUtils.handleProgram(model, program);
        return model;
    }

    public static void handleProgram(Model model, Program program) {
        Resource SDTH_PROGRAM = model.createResource("http://rdf-vocabulary.ddialliance.org/sdth#Program");
        String id = program.getId();
        String label = program.getLabel();
        Resource programURI = model.createResource("http://trevas/program/" + id);
        programURI.addProperty(RDF.type, (RDFNode)SDTH_PROGRAM);
        programURI.addProperty(RDFS.label, label);
        String sourceCode = program.getSourceCode();
        Property SDTH_HAS_SOURCE_CODE = model.createProperty("http://rdf-vocabulary.ddialliance.org/sdth#hasSourceCode");
        programURI.addProperty(SDTH_HAS_SOURCE_CODE, sourceCode);
        Set<ProgramStep> programSteps = program.getProgramSteps();
        Property SDTH_HAS_PROGRAM_STEP = model.createProperty("http://rdf-vocabulary.ddialliance.org/sdth#hasProgramStep");
        programSteps.forEach(step -> {
            String stepId = step.getId();
            Resource programStepURI = model.createResource("http://trevas/program-step/" + stepId);
            programURI.addProperty(SDTH_HAS_PROGRAM_STEP, (RDFNode)programStepURI);
            RDFUtils.handleProgramStep(model, step);
        });
    }

    public static void handleProgramStep(Model model, ProgramStep programStep) {
        String id = programStep.getId();
        Resource programStepURI = model.createResource("http://trevas/program-step/" + id);
        Resource SDTH_PROGRAM_STEP = model.createResource("http://rdf-vocabulary.ddialliance.org/sdth#ProgramStep");
        programStepURI.addProperty(RDF.type, (RDFNode)SDTH_PROGRAM_STEP);
        programStepURI.addProperty(RDFS.label, "Create " + id + " dataset");
        String sourceCode = programStep.getSourceCode();
        Property SDTH_HAS_SOURCE_CODE = model.createProperty("http://rdf-vocabulary.ddialliance.org/sdth#hasSourceCode");
        programStepURI.addProperty(SDTH_HAS_SOURCE_CODE, sourceCode);
        DataframeInstance dfProduced = programStep.getProducedDataframe();
        String dfProducedId = dfProduced.getId();
        Resource dfProducesURI = model.createResource("http://trevas/dataset/" + dfProducedId);
        Property SDTH_PRODUCES_DATAFRAME = model.createProperty("http://rdf-vocabulary.ddialliance.org/sdth#producesDataframe");
        programStepURI.addProperty(SDTH_PRODUCES_DATAFRAME, (RDFNode)dfProducesURI);
        RDFUtils.handleDataframeInstance(model, dfProduced);
        Property SDTH_CONSUMES_DATAFRAME = model.createProperty("http://rdf-vocabulary.ddialliance.org/sdth#consumesDataframe");
        programStep.getConsumedDataframe().forEach(df -> {
            Resource dfConsumedURI = model.createResource("http://trevas/dataset/" + df.getId());
            programStepURI.addProperty(SDTH_CONSUMES_DATAFRAME, (RDFNode)dfConsumedURI);
            RDFUtils.handleDataframeInstance(model, df);
        });
        Property SDTH_USED_VARIABLE = model.createProperty("http://rdf-vocabulary.ddialliance.org/sdth#usesVariable");
        programStep.getUsedVariables().forEach(v -> {
            Resource varUsedURI = model.createResource("http://trevas/variable/" + v.getId());
            programStepURI.addProperty(SDTH_USED_VARIABLE, (RDFNode)varUsedURI);
            RDFUtils.handleVariableInstance(model, v);
        });
        Property SDTH_ASSIGNED_VARIABLE = model.createProperty("http://rdf-vocabulary.ddialliance.org/sdth#assignsVariable");
        programStep.getAssignedVariables().forEach(v -> {
            Resource varAssignedURI = model.createResource("http://trevas/variable/" + v.getId());
            programStepURI.addProperty(SDTH_ASSIGNED_VARIABLE, (RDFNode)varAssignedURI);
            RDFUtils.handleVariableInstance(model, v);
        });
    }

    public static void handleDataframeInstance(Model model, DataframeInstance dfInstance) {
        String id = dfInstance.getId();
        Resource dfURI = model.createResource("http://trevas/dataset/" + id);
        Resource SDTH_DATAFRAME = model.createResource("http://rdf-vocabulary.ddialliance.org/sdth#DataframeInstance");
        dfURI.addProperty(RDF.type, (RDFNode)SDTH_DATAFRAME);
        String label = dfInstance.getLabel();
        dfURI.addProperty(RDFS.label, label);
    }

    public static void handleVariableInstance(Model model, VariableInstance varInstance) {
        String id = varInstance.getId();
        Resource varURI = model.createResource("http://trevas/variable/" + id);
        Resource SDTH_VARIABLE = model.createResource("http://rdf-vocabulary.ddialliance.org/sdth#VariableInstance");
        varURI.addProperty(RDF.type, (RDFNode)SDTH_VARIABLE);
        String label = varInstance.getLabel();
        varURI.addProperty(RDFS.label, label);
    }

    public static Model initModel(String baseFilePath) {
        Model model = ModelFactory.createDefaultModel();
        model.read(baseFilePath);
        return model;
    }

    public static void loadModelWithCredentials(Model model, String sparqlEndpoint, String sparqlEndpointUser, String sparqlEndpointPassword) {
        if (!sparqlEndpoint.isEmpty()) {
            RDFConnection connection = RDFConnectionFactory.connectPW((String)sparqlEndpoint, (String)sparqlEndpointUser, (String)sparqlEndpointPassword);
            connection.fetchDataset();
            connection.load(model);
            connection.close();
        }
    }

    public static void writeJsonLdToFile(Model model, String path) throws IOException {
        model.write(Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]), "JSON-LD");
    }

    public static String serialize(Model model, String format) {
        StringWriter stringWriter = new StringWriter();
        model.write((Writer)stringWriter, format);
        return stringWriter.toString();
    }
}

