/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.prov;

import java.util.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;

public class Variable {
    private final ParserRuleContext nameCtx;
    private final ParserRuleContext exprCtx;
    private Integer version = 0;
    private Variable previous;

    private static String getText(ParserRuleContext ctx) {
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        return start.getInputStream().getText(new Interval(start.getStartIndex(), stop.getStopIndex()));
    }

    Variable(ParserRuleContext name, ParserRuleContext expression) {
        this.nameCtx = name;
        this.exprCtx = expression;
    }

    public Variable(ParserRuleContext name) {
        this.nameCtx = name;
        this.exprCtx = null;
    }

    public String getName() {
        return Variable.getText(this.nameCtx);
    }

    public String getVersion() {
        return this.getName() + "_" + this.version;
    }

    public Optional<String> getExpression() {
        return Optional.ofNullable(this.exprCtx).map(Variable::getText);
    }

    public Optional<Variable> getPrevious() {
        return Optional.ofNullable(this.previous);
    }

    public Variable newVersion() {
        Variable copy = new Variable(this.nameCtx, this.exprCtx);
        copy.version = this.version + 1;
        copy.previous = this;
        return copy;
    }

    public String toString() {
        return this.getVersion();
    }

    public final boolean isSame(Variable other) {
        return this.nameCtx.equals(other.nameCtx);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)o;
        return this.getVersion().equals(variable.getVersion());
    }

    public int hashCode() {
        return this.nameCtx.hashCode();
    }
}

