/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.prov;

import fr.insee.vtl.parser.VtlBaseListener;
import fr.insee.vtl.parser.VtlParser;
import fr.insee.vtl.prov.Variable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class VariableGraphListener
extends VtlBaseListener {
    private Variable current;
    private final Map<String, Variable> seen = new LinkedHashMap<String, Variable>();
    private final DefaultDirectedGraph<Variable, DefaultEdge> graph = new DefaultDirectedGraph(DefaultEdge.class);

    private void setCurrent(ParserRuleContext id, ParserRuleContext expression) {
        assert (this.current == null);
        this.current = new Variable(id, expression);
        if (this.seen.containsKey(this.current.getName())) {
            this.current = this.seen.get(this.current.getName()).newVersion();
        }
    }

    private void resetCurrent() {
        assert (this.current != null);
        this.seen.put(this.current.getName(), this.current);
        this.current = null;
    }

    public void enterTemporaryAssignment(VtlParser.TemporaryAssignmentContext ctx) {
        this.setCurrent((ParserRuleContext)ctx.varID(), (ParserRuleContext)ctx.expr());
    }

    public void exitTemporaryAssignment(VtlParser.TemporaryAssignmentContext ctx) {
        this.resetCurrent();
    }

    public void enterPersistAssignment(VtlParser.PersistAssignmentContext ctx) {
        this.setCurrent((ParserRuleContext)ctx.varID(), (ParserRuleContext)ctx.expr());
    }

    public void exitPersistAssignment(VtlParser.PersistAssignmentContext ctx) {
        this.resetCurrent();
    }

    public void enterVarID(VtlParser.VarIDContext ctx) {
        assert (this.current != null);
        Variable newVariable = new Variable((ParserRuleContext)ctx);
        if (newVariable.isSame(this.current)) {
            return;
        }
        if (this.seen.containsKey(newVariable.getName())) {
            newVariable = this.seen.get(newVariable.getName());
        } else {
            this.seen.put(newVariable.getName(), newVariable);
        }
        this.graph.addVertex((Object)newVariable);
        this.graph.addVertex((Object)this.current);
        this.graph.addEdge((Object)newVariable, (Object)this.current);
    }

    public DefaultDirectedGraph<Variable, DefaultEdge> getGraph() {
        Set selfLoops = this.graph.edgeSet().stream().filter(e -> ((Variable)this.graph.getEdgeSource(e)).equals(this.graph.getEdgeTarget(e))).collect(Collectors.toSet());
        this.graph.removeAllEdges(selfLoops);
        return this.graph;
    }

    public Set<Variable> getVariables() {
        return this.graph.vertexSet().stream().filter(v -> this.graph.outgoingEdgesOf(v).isEmpty()).collect(Collectors.toSet());
    }
}

