/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp;

import com.google.code.jgntp.GntpApplicationInfo;
import com.google.code.jgntp.GntpApplicationInfoBuilder;
import com.google.code.jgntp.GntpClient;
import com.google.code.jgntp.GntpListener;
import com.google.code.jgntp.GntpNotificationBuilder;
import com.google.code.jgntp.GntpNotificationInfo;
import com.google.code.jgntp.GntpNotificationInfoBuilder;
import com.google.code.jgntp.GntpPassword;
import com.google.code.jgntp.internal.GntpPasswordDefaultImpl;
import com.google.code.jgntp.internal.io.NioTcpGntpClient;
import com.google.code.jgntp.internal.io.NioUdpGntpClient;
import com.shaded.notifier.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Gntp {
    public static final String CUSTOM_HEADER_PREFIX = "X-";
    public static final String APP_SPECIFIC_HEADER_PREFIX = "Data-";
    public static final int WINDOWS_TCP_PORT = 23053;
    public static final int MAC_TCP_PORT = 23052;
    public static final int UDP_PORT = 9887;
    public static final long DEFAULT_RETRY_TIME = 3L;
    public static final TimeUnit DEFAULT_RETRY_TIME_UNIT = TimeUnit.SECONDS;
    public static final int DEFAULT_NOTIFICATION_RETRIES = 3;
    private GntpApplicationInfo applicationInfo;
    private SocketAddress growlAddress;
    private boolean tcp;
    private String growlHost;
    private int growlPort;
    private Executor executor;
    private GntpListener listener;
    private GntpPassword password;
    private boolean encrypted;
    private long retryTime;
    private TimeUnit retryTimeUnit;
    private int notificationRetryCount;

    private Gntp(GntpApplicationInfo applicationInfo) {
        Preconditions.checkNotNull(applicationInfo, "Application info must not be null");
        this.applicationInfo = applicationInfo;
        this.tcp = true;
        this.growlPort = this.getTcpPort();
        this.retryTime = 3L;
        this.retryTimeUnit = DEFAULT_RETRY_TIME_UNIT;
        this.notificationRetryCount = 3;
    }

    public static GntpApplicationInfoBuilder appInfo(String name) {
        return new GntpApplicationInfoBuilder(name);
    }

    public static GntpNotificationInfoBuilder notificationInfo(GntpApplicationInfo applicationInfo, String name) {
        return new GntpNotificationInfoBuilder(applicationInfo, name);
    }

    public static GntpNotificationBuilder notification(GntpNotificationInfo info, String title) {
        return new GntpNotificationBuilder(info, title);
    }

    public static GntpPassword password(String textPassword) {
        return new GntpPasswordDefaultImpl(textPassword);
    }

    public static Gntp client(GntpApplicationInfo applicationInfo) {
        return new Gntp(applicationInfo);
    }

    public Gntp forAddress(SocketAddress address) {
        this.growlAddress = address;
        return this;
    }

    public Gntp forHost(String host) {
        Preconditions.checkNotNull(host, "Growl host must not be null");
        this.growlHost = host;
        return this;
    }

    public Gntp onPort(int port) {
        Preconditions.checkArgument(port > 0, "Port must not be negative");
        this.growlPort = port;
        return this;
    }

    public Gntp withTcp() {
        this.tcp = true;
        if (this.growlPort == 9887) {
            this.growlPort = this.getTcpPort();
        }
        return this;
    }

    public Gntp withUdp() {
        throw new UnsupportedOperationException("The Growl UDP protocol is not supported");
    }

    public Gntp executor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public Gntp listener(GntpListener listener) {
        this.listener = listener;
        return this;
    }

    public Gntp withPassword(String textPassword) {
        this.password = Gntp.password(textPassword);
        return this;
    }

    public Gntp withPassword(GntpPassword password) {
        this.password = password;
        return this;
    }

    public Gntp secure(String password) {
        this.withPassword(password);
        this.encrypted = true;
        return this;
    }

    public Gntp secure(GntpPassword password) {
        this.withPassword(password);
        this.encrypted = true;
        return this;
    }

    public Gntp insecure() {
        this.encrypted = false;
        return this;
    }

    public Gntp retryingAtFixedRate(long time, TimeUnit unit) {
        Preconditions.checkArgument(time > 0L, "Retry time must be greater than zero");
        Preconditions.checkArgument(unit != null, "Retry time unit must not be null");
        this.retryTime = time;
        this.retryTimeUnit = unit;
        return this;
    }

    public Gntp retryingNotificationsAtMost(int notificationRetryCount) {
        this.notificationRetryCount = notificationRetryCount;
        return this;
    }

    public Gntp withoutRetry() {
        this.retryTime = 0L;
        this.retryTimeUnit = DEFAULT_RETRY_TIME_UNIT;
        this.notificationRetryCount = 0;
        return this;
    }

    public GntpClient build() {
        Executor executorToUse;
        if (this.growlAddress == null) {
            this.growlAddress = new InetSocketAddress(this.getInetAddress(this.growlHost), this.growlPort);
        }
        if (!this.tcp && this.listener != null) {
            throw new IllegalArgumentException("Cannot set listener on a non-TCP client");
        }
        Executor executor = executorToUse = this.executor == null ? Executors.newCachedThreadPool() : this.executor;
        if (this.tcp) {
            return new NioTcpGntpClient(this.applicationInfo, this.growlAddress, executorToUse, this.listener, this.password, this.encrypted, this.retryTime, this.retryTimeUnit, this.notificationRetryCount);
        }
        return new NioUdpGntpClient(this.applicationInfo, this.growlAddress, executorToUse, this.password, this.encrypted);
    }

    private int getTcpPort() {
        String osName = System.getProperty("os.name");
        if (osName != null && (osName = osName.toLowerCase()).contains("mac")) {
            return 23052;
        }
        return 23053;
    }

    private InetAddress getInetAddress(String name) {
        if (name == null) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                try {
                    return InetAddress.getByName(name);
                }
                catch (UnknownHostException uhe) {
                    throw new IllegalStateException("Could not find localhost", uhe);
                }
            }
        }
        try {
            return InetAddress.getByName(name);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Could not find inet address: " + name, e);
        }
    }
}

