/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp;

public enum GntpErrorStatus {
    RESERVED(100),
    TIMED_OUT(200),
    NETWORK_FAILURE(201),
    INVALID_REQUEST(300),
    UNKNOWN_PROTOCOL(301),
    UNKNOWN_PROTOCOL_VERSION(302),
    REQUIRED_HEADER_MISSING(303),
    NOT_AUTHORIZED(400),
    UNKNOWN_APPLICATION(401),
    UNKNOWN_NOTIFICATION(402),
    INTERNAL_SERVER_ERROR(500);

    private int code;

    private GntpErrorStatus(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static GntpErrorStatus parse(String s) {
        return GntpErrorStatus.of(Integer.parseInt(s));
    }

    public static GntpErrorStatus of(int i) {
        for (GntpErrorStatus status : GntpErrorStatus.values()) {
            if (status.getCode() != i) continue;
            return status;
        }
        return null;
    }
}

