/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp;

import com.google.code.jgntp.GntpNotification;
import com.google.code.jgntp.GntpNotificationInfo;
import com.google.code.jgntp.internal.GntpNotificationDefaultImpl;
import com.shaded.notifier.google.common.base.Preconditions;
import com.shaded.notifier.google.common.collect.Maps;
import java.awt.image.RenderedImage;
import java.net.URI;
import java.util.Map;

public class GntpNotificationBuilder {
    private String applicationName;
    private String name;
    private String id;
    private String title;
    private String text;
    private Boolean sticky;
    private GntpNotification.Priority priority;
    private RenderedImage iconImage;
    private URI iconUri;
    private String coalescingId;
    private URI callbackTarget;
    private boolean callbackRequested;
    private Object context;
    private Map<String, Object> customHeaders;

    public GntpNotificationBuilder(GntpNotificationInfo info, String title) {
        Preconditions.checkNotNull(info, "Notification info must not be null");
        this.applicationName = info.getApplicationInfo().getName();
        this.name = info.getName();
        this.title = title;
        this.customHeaders = Maps.newHashMap();
    }

    public GntpNotificationBuilder info(GntpNotificationInfo info) {
        Preconditions.checkNotNull(info, "Notification info must not be null");
        this.applicationName = info.getApplicationInfo().getName();
        this.name = info.getName();
        return this;
    }

    public GntpNotificationBuilder id(String id) {
        this.id = id;
        return this;
    }

    public GntpNotificationBuilder title(String title) {
        Preconditions.checkNotNull(title, "Notification title must not be null");
        this.title = title;
        return this;
    }

    public GntpNotificationBuilder text(String text) {
        this.text = text;
        return this;
    }

    public GntpNotificationBuilder sticky(Boolean sticky) {
        this.sticky = sticky;
        return this;
    }

    public GntpNotificationBuilder priority(GntpNotification.Priority priority) {
        this.priority = priority;
        return this;
    }

    public GntpNotificationBuilder icon(RenderedImage image) {
        this.iconImage = image;
        this.iconUri = null;
        return this;
    }

    public GntpNotificationBuilder icon(URI uri) {
        this.iconUri = uri;
        this.iconImage = null;
        return this;
    }

    public GntpNotificationBuilder coalescingId(String coalescingId) {
        this.coalescingId = coalescingId;
        return this;
    }

    public GntpNotificationBuilder callbackTarget(URI callbackTarget) {
        this.callbackTarget = callbackTarget;
        this.callbackRequested = false;
        return this;
    }

    public GntpNotificationBuilder withCallback() {
        this.callbackRequested = true;
        this.callbackTarget = null;
        return this;
    }

    public GntpNotificationBuilder withoutCallback() {
        this.callbackRequested = false;
        return this;
    }

    public GntpNotificationBuilder context(Object context) {
        this.context = context;
        return this;
    }

    public GntpNotificationBuilder header(String name, Object value) {
        this.customHeaders.put(name, value);
        return this;
    }

    public GntpNotification build() {
        return new GntpNotificationDefaultImpl(this.applicationName, this.name, this.id, this.title, this.text, this.sticky, this.priority, this.iconImage, this.iconUri, this.coalescingId, this.callbackTarget, this.callbackRequested, this.context, this.customHeaders);
    }
}

