/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp;

import com.google.code.jgntp.GntpApplicationInfo;
import com.google.code.jgntp.GntpNotificationInfo;
import com.google.code.jgntp.internal.GntpNotificationInfoDefaultImpl;
import java.awt.image.RenderedImage;
import java.net.URI;

public class GntpNotificationInfoBuilder {
    private GntpApplicationInfo applicationInfo;
    private String name;
    private String displayName;
    private boolean enabled;
    private RenderedImage iconImage;
    private URI iconUri;

    public GntpNotificationInfoBuilder(GntpApplicationInfo applicationInfo, String name) {
        this.applicationInfo = applicationInfo;
        this.name = name;
        this.enabled = true;
    }

    public GntpNotificationInfoBuilder applicationInfo(GntpApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    public GntpNotificationInfoBuilder name(String name) {
        this.name = name;
        return this;
    }

    public GntpNotificationInfoBuilder displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public GntpNotificationInfoBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public GntpNotificationInfoBuilder icon(RenderedImage image) {
        this.iconImage = image;
        this.iconUri = null;
        return this;
    }

    public GntpNotificationInfoBuilder icon(URI uri) {
        this.iconUri = uri;
        this.iconImage = null;
        return this;
    }

    public GntpNotificationInfo build() {
        GntpNotificationInfoDefaultImpl info = new GntpNotificationInfoDefaultImpl(this.applicationInfo, this.name, this.displayName, this.enabled, this.iconImage, this.iconUri);
        this.applicationInfo.addNotificationInfo(info);
        return info;
    }
}

