/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal;

import com.google.code.jgntp.GntpApplicationInfo;
import com.google.code.jgntp.GntpNotificationInfo;
import com.shaded.notifier.google.common.base.Preconditions;
import com.shaded.notifier.google.common.collect.Lists;
import java.awt.image.RenderedImage;
import java.net.URI;
import java.util.List;

public class GntpApplicationInfoDefaultImpl
implements GntpApplicationInfo {
    private final String name;
    private final RenderedImage iconImage;
    private final URI iconUri;
    private final List<GntpNotificationInfo> notificationInfos;

    public GntpApplicationInfoDefaultImpl(String name, RenderedImage iconImage, URI iconUri) {
        Preconditions.checkNotNull(name, "Application name must not be null");
        this.name = name;
        this.iconImage = iconImage;
        this.iconUri = iconUri;
        this.notificationInfos = Lists.newArrayList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RenderedImage getIconImage() {
        return this.iconImage;
    }

    @Override
    public URI getIconUri() {
        return this.iconUri;
    }

    @Override
    public List<GntpNotificationInfo> getNotificationInfos() {
        return this.notificationInfos;
    }

    @Override
    public void addNotificationInfo(GntpNotificationInfo notificationInfo) {
        this.notificationInfos.add(notificationInfo);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GntpApplicationInfoDefaultImpl other = (GntpApplicationInfoDefaultImpl)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }
}

