/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal;

import com.google.code.jgntp.GntpNotification;
import com.shaded.notifier.google.common.base.Preconditions;
import com.shaded.notifier.google.common.collect.ImmutableMap;
import java.awt.image.RenderedImage;
import java.net.URI;
import java.util.Map;

public class GntpNotificationDefaultImpl
implements GntpNotification {
    private final String applicationName;
    private final String name;
    private final String id;
    private final String title;
    private final String text;
    private final Boolean sticky;
    private final GntpNotification.Priority priority;
    private final RenderedImage iconImage;
    private final URI iconUri;
    private final String coalescingId;
    private final URI callbackTarget;
    private final boolean callbackRequested;
    private final Object context;
    private final Map<String, Object> customHeaders;

    public GntpNotificationDefaultImpl(String applicationName, String name, String id, String title, String text, Boolean sticky, GntpNotification.Priority priority, RenderedImage iconImage, URI iconUri, String coalescingId, URI callbackTarget, boolean callbackRequested, Object context, Map<String, Object> customHeaders) {
        Preconditions.checkNotNull(applicationName, "Application name must not be null");
        Preconditions.checkNotNull(name, "Notification name must not be null");
        Preconditions.checkNotNull(title, "Notification title must not be null");
        this.applicationName = applicationName;
        this.name = name;
        this.id = id;
        this.title = title;
        this.text = text;
        this.sticky = sticky;
        this.priority = priority;
        this.iconImage = iconImage;
        this.iconUri = iconUri;
        this.coalescingId = coalescingId;
        this.callbackTarget = callbackTarget;
        this.callbackRequested = callbackRequested;
        this.context = context;
        this.customHeaders = ImmutableMap.copyOf(customHeaders);
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Boolean isSticky() {
        return this.sticky;
    }

    @Override
    public GntpNotification.Priority getPriority() {
        return this.priority;
    }

    @Override
    public RenderedImage getIconImage() {
        return this.iconImage;
    }

    @Override
    public URI getIconUri() {
        return this.iconUri;
    }

    @Override
    public String getCoalescingId() {
        return this.coalescingId;
    }

    @Override
    public URI getCallbackTarget() {
        return this.callbackTarget;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public boolean isCallbackRequested() {
        return this.callbackRequested;
    }

    @Override
    public Map<String, Object> getCustomHeaders() {
        return this.customHeaders;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("application=").append(this.applicationName);
        sb.append(", name=").append(this.name);
        sb.append(", title=").append(this.title);
        sb.append(", text=").append(this.text);
        sb.append(", callbackRequested=").append(this.callbackRequested);
        if (this.id != null) {
            sb.append(", id=").append(this.id);
        }
        if (this.sticky != null) {
            sb.append(", sticky=").append(this.sticky);
        }
        if (this.priority != null) {
            sb.append(", priority=").append((Object)this.priority);
        }
        if (this.iconImage != null) {
            sb.append(", iconImage=true");
        }
        if (this.iconUri != null) {
            sb.append(", iconUri=").append(this.iconUri);
        }
        if (this.coalescingId != null) {
            sb.append(", coalescingId=").append(this.coalescingId);
        }
        if (this.callbackTarget != null) {
            sb.append(", callbackTarget=").append(this.callbackTarget);
        }
        if (this.context != null) {
            sb.append(", context=").append(this.context);
        }
        if (!this.customHeaders.isEmpty()) {
            sb.append(", customHeaders=").append(this.customHeaders);
        }
        return sb.toString();
    }
}

