/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal;

import com.google.code.jgntp.GntpApplicationInfo;
import com.google.code.jgntp.GntpNotificationInfo;
import com.shaded.notifier.google.common.base.Preconditions;
import java.awt.image.RenderedImage;
import java.net.URI;

public class GntpNotificationInfoDefaultImpl
implements GntpNotificationInfo {
    private final GntpApplicationInfo applicationInfo;
    private final String name;
    private final String displayName;
    private final boolean enabled;
    private final RenderedImage iconImage;
    private final URI iconUri;

    public GntpNotificationInfoDefaultImpl(GntpApplicationInfo applicationInfo, String name, String displayName, boolean enabled, RenderedImage iconImage, URI iconUri) {
        Preconditions.checkNotNull(applicationInfo, "Application info must not be null");
        Preconditions.checkNotNull(name, "Notification name must not be null");
        this.applicationInfo = applicationInfo;
        this.name = name;
        this.displayName = displayName;
        this.enabled = enabled;
        this.iconImage = iconImage;
        this.iconUri = iconUri;
    }

    @Override
    public GntpApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public RenderedImage getIconImage() {
        return this.iconImage;
    }

    @Override
    public URI getIconUri() {
        return this.iconUri;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.applicationInfo == null ? 0 : this.applicationInfo.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GntpNotificationInfoDefaultImpl other = (GntpNotificationInfoDefaultImpl)obj;
        if (this.applicationInfo == null ? other.applicationInfo != null : !this.applicationInfo.equals(other.applicationInfo)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return String.format("name=%s, displayName=%s, enabled=%s, iconImage=%s, iconUri=%s", this.name, this.displayName, this.enabled, this.iconImage, this.iconUri);
    }
}

