/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal;

import com.google.code.jgntp.GntpPassword;
import com.shaded.notifier.google.common.base.Charsets;
import com.shaded.notifier.google.common.base.Preconditions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;

public class GntpPasswordDefaultImpl
implements GntpPassword {
    public static final String DEFAULT_RANDOM_SALT_ALGORITHM = "SHA1PRNG";
    public static final int DEFAULT_SALT_SIZE = 16;
    public static final String DEFAULT_KEY_HASH_ALGORITHM = "SHA-512";
    private final byte[] key;
    private final byte[] keyHash;
    private final byte[] salt;

    public GntpPasswordDefaultImpl(String textPassword) {
        Preconditions.checkNotNull(textPassword, "Text password must not be null");
        byte[] passwordBytes = textPassword.getBytes(Charsets.UTF_8);
        this.salt = this.getSalt(DEFAULT_RANDOM_SALT_ALGORITHM);
        byte[] keyBasis = this.getKeyBasis(passwordBytes, this.salt);
        this.key = this.hash(keyBasis, DEFAULT_KEY_HASH_ALGORITHM);
        this.keyHash = this.hash(this.key, DEFAULT_KEY_HASH_ALGORITHM);
    }

    @Override
    public byte[] getKey() {
        return Arrays.copyOf(this.key, this.key.length);
    }

    @Override
    public byte[] getKeyHash() {
        return Arrays.copyOf(this.keyHash, this.keyHash.length);
    }

    @Override
    public String getKeyHashAlgorithm() {
        return DEFAULT_KEY_HASH_ALGORITHM.replaceAll("-", "");
    }

    @Override
    public byte[] getSalt() {
        return Arrays.copyOf(this.salt, this.salt.length);
    }

    protected byte[] getSalt(String randomSaltAlgorithm) {
        SecureRandom random;
        try {
            random = SecureRandom.getInstance(randomSaltAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        random.setSeed(System.currentTimeMillis());
        byte[] saltArray = new byte[16];
        random.nextBytes(saltArray);
        return saltArray;
    }

    protected byte[] getKeyBasis(byte[] password, byte[] saltToUse) {
        byte[] keyBasis = new byte[password.length + saltToUse.length];
        System.arraycopy(password, 0, keyBasis, 0, password.length);
        System.arraycopy(saltToUse, 0, keyBasis, password.length, saltToUse.length);
        return keyBasis;
    }

    protected byte[] hash(byte[] keyToUse, String hashAlgorithm) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm);
            return messageDigest.digest(keyToUse);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

