/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.io;

import com.shaded.notifier.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DelimiterBasedFrameEncoder
extends OneToOneEncoder {
    private static final String DUMP_MESSAGES_DIRECTORY_PROPERTY = "gntp.request.dump.dir";
    private static final Logger logger = LoggerFactory.getLogger(DelimiterBasedFrameEncoder.class);
    private final ChannelBuffer delimiter;
    private File dumpDir;
    private AtomicLong dumpCounter;

    public DelimiterBasedFrameEncoder(ChannelBuffer delimiter) {
        this.delimiter = ChannelBuffers.copiedBuffer(delimiter);
        String dumpDirName = System.getProperty(DUMP_MESSAGES_DIRECTORY_PROPERTY);
        File file = this.dumpDir = dumpDirName == null ? null : new File(dumpDirName);
        if (this.dumpDir != null) {
            this.dumpCounter = new AtomicLong();
            try {
                Files.createParentDirs(this.dumpDir);
            }
            catch (IOException e) {
                logger.warn("Could not get/create GNTP request dump directory, dumping will be disabled", (Throwable)e);
                this.dumpDir = null;
            }
        }
    }

    @Override
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((ChannelBuffer)msg, this.delimiter);
        if (this.dumpDir != null) {
            try {
                String fileName = "gntp-request-" + this.dumpCounter.getAndIncrement() + ".out";
                byte[] b = new byte[buffer.readableBytes()];
                buffer.getBytes(0, b);
                Files.write(b, new File(this.dumpDir, fileName));
            }
            catch (IOException e) {
                logger.warn("Could not save GNTP request dump", (Throwable)e);
            }
        }
        return buffer;
    }
}

