/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.io;

import com.google.code.jgntp.GntpErrorStatus;
import com.google.code.jgntp.GntpListener;
import com.google.code.jgntp.GntpNotification;
import com.google.code.jgntp.internal.io.NioGntpClient;
import com.google.code.jgntp.internal.message.GntpCallbackMessage;
import com.google.code.jgntp.internal.message.GntpErrorMessage;
import com.google.code.jgntp.internal.message.GntpMessageResponse;
import com.google.code.jgntp.internal.message.GntpMessageType;
import com.google.code.jgntp.internal.message.GntpOkMessage;
import com.shaded.notifier.google.common.base.Preconditions;
import java.io.IOException;
import java.net.ConnectException;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GntpChannelHandler
extends SimpleChannelUpstreamHandler {
    private Logger logger = LoggerFactory.getLogger(GntpChannelHandler.class);
    private final NioGntpClient gntpClient;
    private final GntpListener listener;

    public GntpChannelHandler(NioGntpClient gntpClient, GntpListener listener) {
        this.gntpClient = gntpClient;
        this.listener = listener;
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.logger.trace("Channel closed [{}]", (Object)e.getChannel());
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        GntpMessageResponse message = (GntpMessageResponse)e.getMessage();
        this.handleMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        try {
            Throwable cause = e.getCause();
            if (this.gntpClient.isRegistered()) {
                this.handleIOError(cause);
            } else if (cause instanceof ConnectException) {
                this.handleIOError(cause);
                this.gntpClient.retryRegistration();
            } else if (cause instanceof IOException) {
                this.handleMessage(new GntpOkMessage(-1L, GntpMessageType.REGISTER, null));
            } else {
                this.handleIOError(cause);
            }
        }
        finally {
            e.getChannel().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleMessage(GntpMessageResponse message) {
        Preconditions.checkState(message instanceof GntpOkMessage || message instanceof GntpCallbackMessage || message instanceof GntpErrorMessage);
        if (this.gntpClient.isRegistered()) {
            GntpNotification notification = (GntpNotification)this.gntpClient.getNotificationsSent().get(message.getInternalNotificationId());
            if (notification == null) return;
            if (message instanceof GntpOkMessage) {
                try {
                    if (this.listener == null) return;
                    this.listener.onNotificationSuccess(notification);
                    return;
                }
                finally {
                    if (!notification.isCallbackRequested()) {
                        this.gntpClient.getNotificationsSent().remove(message.getInternalNotificationId());
                    }
                }
            } else if (message instanceof GntpCallbackMessage) {
                this.gntpClient.getNotificationsSent().remove(message.getInternalNotificationId());
                if (this.listener == null) {
                    throw new IllegalStateException("A GntpListener must be set in GntpClient to be able to receive callbacks");
                }
                GntpCallbackMessage callbackMessage = (GntpCallbackMessage)message;
                switch (callbackMessage.getCallbackResult()) {
                    case CLICK: {
                        this.listener.onClickCallback(notification);
                        return;
                    }
                    case CLOSE: {
                        this.listener.onCloseCallback(notification);
                        return;
                    }
                    case TIMEOUT: {
                        this.listener.onTimeoutCallback(notification);
                        return;
                    }
                    default: {
                        throw new IllegalStateException("Unknown callback result: " + (Object)((Object)callbackMessage.getCallbackResult()));
                    }
                }
            } else {
                if (!(message instanceof GntpErrorMessage)) return;
                GntpErrorMessage errorMessage = (GntpErrorMessage)message;
                if (this.listener != null) {
                    this.listener.onNotificationError(notification, errorMessage.getStatus(), errorMessage.getDescription());
                }
                if (GntpErrorStatus.UNKNOWN_APPLICATION != errorMessage.getStatus() && GntpErrorStatus.UNKNOWN_NOTIFICATION != errorMessage.getStatus()) return;
                this.gntpClient.retryRegistration();
            }
            return;
        } else if (message instanceof GntpOkMessage) {
            try {
                if (this.listener == null) return;
                this.listener.onRegistrationSuccess();
                return;
            }
            finally {
                this.gntpClient.setRegistered();
            }
        } else {
            if (!(message instanceof GntpErrorMessage)) return;
            GntpErrorMessage errorMessage = (GntpErrorMessage)message;
            if (this.listener != null) {
                this.listener.onRegistrationError(errorMessage.getStatus(), errorMessage.getDescription());
            }
            if (GntpErrorStatus.NOT_AUTHORIZED != errorMessage.getStatus()) return;
            this.gntpClient.retryRegistration();
        }
    }

    protected void handleIOError(Throwable t) {
        if (this.listener == null) {
            this.logger.error("Error in GNTP I/O operation", t);
        } else {
            this.listener.onCommunicationError(t);
        }
    }
}

