/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.io;

import com.google.code.jgntp.internal.io.DelimiterBasedFrameEncoder;
import com.google.code.jgntp.internal.io.GntpMessageDecoder;
import com.google.code.jgntp.internal.io.GntpMessageEncoder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;

public class GntpChannelPipelineFactory
implements ChannelPipelineFactory {
    private final ChannelHandler delimiterEncoder = new DelimiterBasedFrameEncoder(this.getDelimiter());
    private final ChannelHandler messageDecoder = new GntpMessageDecoder();
    private final ChannelHandler messageEncoder = new GntpMessageEncoder();
    private final ChannelHandler handler;

    public GntpChannelPipelineFactory(ChannelHandler handler) {
        this.handler = handler;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("delimiter-decoder", new DelimiterBasedFrameDecoder(Integer.MAX_VALUE, this.getDelimiter()));
        pipeline.addLast("delimiter-encoder", this.delimiterEncoder);
        pipeline.addLast("message-decoder", this.messageDecoder);
        pipeline.addLast("message-encoder", this.messageEncoder);
        pipeline.addLast("handler", this.handler);
        return pipeline;
    }

    protected ChannelBuffer getDelimiter() {
        return ChannelBuffers.wrappedBuffer(new byte[]{13, 10, 13, 10});
    }
}

