/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.io;

import com.google.code.jgntp.internal.message.GntpMessage;
import com.google.code.jgntp.internal.message.read.GntpMessageResponseParser;
import com.shaded.notifier.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class GntpMessageDecoder
extends OneToOneDecoder {
    public static final String LOGGER_NAME = "jgntp.message";
    private static final Logger logger = LoggerFactory.getLogger((String)"jgntp.message");
    private static final String DUMP_MESSAGES_DIRECTORY_PROPERTY = "gntp.response.dump.dir";
    private final GntpMessageResponseParser parser = new GntpMessageResponseParser();
    private File dumpDir;
    private AtomicLong dumpCounter;

    public GntpMessageDecoder() {
        String dumpDirName = System.getProperty(DUMP_MESSAGES_DIRECTORY_PROPERTY);
        File file = this.dumpDir = dumpDirName == null ? null : new File(dumpDirName);
        if (this.dumpDir != null) {
            this.dumpCounter = new AtomicLong();
            try {
                Files.createParentDirs(this.dumpDir);
            }
            catch (IOException e) {
                logger.warn("Could not get/create GNTP response dump directory, dumping will be disabled", (Throwable)e);
                this.dumpDir = null;
            }
        }
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        ChannelBuffer buffer = (ChannelBuffer)msg;
        byte[] b = new byte[buffer.readableBytes()];
        buffer.getBytes(0, b);
        String s = new String(b, GntpMessage.ENCODING);
        if (logger.isDebugEnabled()) {
            logger.debug("Message received\n{}", (Object)s);
        }
        if (this.dumpDir != null) {
            try {
                String fileName = "gntp-response-" + this.dumpCounter.getAndIncrement() + ".out";
                Files.write(b, new File(this.dumpDir, fileName));
            }
            catch (IOException e) {
                logger.warn("Could not save GNTP request dump", (Throwable)e);
            }
        }
        return this.parser.parse(s);
    }
}

