/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.io;

import com.google.code.jgntp.internal.message.GntpMessage;
import com.google.code.jgntp.internal.util.MultiOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class GntpMessageEncoder
extends SimpleChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"jgntp.message");

    @Override
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        OutputStream outputStream;
        ByteArrayOutputStream debugOutputStream;
        GntpMessage message = (GntpMessage)e.getMessage();
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        if (logger.isDebugEnabled()) {
            debugOutputStream = new ByteArrayOutputStream();
            outputStream = new MultiOutputStream(new ChannelBufferOutputStream(buffer), debugOutputStream);
        } else {
            debugOutputStream = null;
            outputStream = new ChannelBufferOutputStream(buffer);
        }
        message.append(outputStream);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending message\n{}", (Object)new String(debugOutputStream.toByteArray(), GntpMessage.ENCODING));
        }
        Channels.write(ctx, e.getFuture(), buffer, e.getRemoteAddress());
    }
}

