/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.io;

import com.google.code.jgntp.GntpApplicationInfo;
import com.google.code.jgntp.GntpClient;
import com.google.code.jgntp.GntpNotification;
import com.google.code.jgntp.GntpPassword;
import com.shaded.notifier.google.common.base.Preconditions;
import com.shaded.notifier.google.common.collect.BiMap;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NioGntpClient
implements GntpClient {
    private static final Logger logger = LoggerFactory.getLogger(NioGntpClient.class);
    private final GntpApplicationInfo applicationInfo;
    private final GntpPassword password;
    private final boolean encrypted;
    private final SocketAddress growlAddress;
    private final CountDownLatch registrationLatch;
    private volatile boolean closed;

    public NioGntpClient(GntpApplicationInfo applicationInfo, SocketAddress growlAddress, GntpPassword password, boolean encrypted) {
        Preconditions.checkNotNull(applicationInfo, "Application info must not be null");
        Preconditions.checkNotNull(growlAddress, "Address must not be null");
        if (encrypted) {
            Preconditions.checkNotNull(password, "Password must not be null if sending encrypted messages");
        }
        this.applicationInfo = applicationInfo;
        this.password = password;
        this.encrypted = encrypted;
        this.growlAddress = growlAddress;
        this.registrationLatch = new CountDownLatch(1);
    }

    protected abstract void doRegister();

    protected abstract void doNotify(GntpNotification var1);

    protected abstract void doShutdown(long var1, TimeUnit var3) throws InterruptedException;

    abstract BiMap<Long, Object> getNotificationsSent();

    abstract void retryRegistration();

    @Override
    public void register() {
        if (this.isShutdown()) {
            throw new IllegalStateException("GntpClient has been shutdown");
        }
        logger.debug("Registering GNTP application [{}]", (Object)this.applicationInfo);
        this.doRegister();
    }

    @Override
    public boolean isRegistered() {
        return this.registrationLatch.getCount() == 0L && !this.isShutdown();
    }

    @Override
    public void waitRegistration() throws InterruptedException {
        this.registrationLatch.await();
    }

    @Override
    public boolean waitRegistration(long time, TimeUnit unit) throws InterruptedException {
        return this.registrationLatch.await(time, unit);
    }

    @Override
    public void notify(GntpNotification notification) {
        boolean interrupted = false;
        while (!this.isShutdown()) {
            try {
                this.waitRegistration();
                this.notifyInternal(notification);
                break;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean notify(GntpNotification notification, long time, TimeUnit unit) throws InterruptedException {
        if (this.waitRegistration(time, unit)) {
            this.notifyInternal(notification);
            return true;
        }
        return false;
    }

    @Override
    public void shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.closed = true;
        this.registrationLatch.countDown();
        this.doShutdown(timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.closed;
    }

    void setRegistered() {
        this.registrationLatch.countDown();
    }

    protected void notifyInternal(GntpNotification notification) {
        if (!this.isShutdown()) {
            logger.debug("Sending notification [{}]", (Object)notification);
            this.doNotify(notification);
        }
    }

    protected GntpApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    protected GntpPassword getPassword() {
        return this.password;
    }

    protected boolean isEncrypted() {
        return this.encrypted;
    }

    protected SocketAddress getGrowlAddress() {
        return this.growlAddress;
    }

    protected CountDownLatch getRegistrationLatch() {
        return this.registrationLatch;
    }
}

