/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.io;

import com.google.code.jgntp.GntpApplicationInfo;
import com.google.code.jgntp.GntpListener;
import com.google.code.jgntp.GntpNotification;
import com.google.code.jgntp.GntpPassword;
import com.google.code.jgntp.internal.io.GntpChannelHandler;
import com.google.code.jgntp.internal.io.GntpChannelPipelineFactory;
import com.google.code.jgntp.internal.io.NioGntpClient;
import com.google.code.jgntp.internal.message.GntpNotifyMessage;
import com.google.code.jgntp.internal.message.GntpRegisterMessage;
import com.shaded.notifier.google.common.base.Preconditions;
import com.shaded.notifier.google.common.collect.BiMap;
import com.shaded.notifier.google.common.collect.HashBiMap;
import com.shaded.notifier.google.common.collect.Maps;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.AdaptiveReceiveBufferSizePredictor;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioTcpGntpClient
extends NioGntpClient {
    private static final Logger logger = LoggerFactory.getLogger(NioTcpGntpClient.class);
    private final long retryTime;
    private final TimeUnit retryTimeUnit;
    private final int notificationRetryCount;
    private final ClientBootstrap bootstrap;
    private final ChannelGroup channelGroup;
    private final ScheduledExecutorService retryExecutorService;
    private volatile boolean tryingRegistration;
    private final AtomicLong notificationIdGenerator;
    private final BiMap<Long, Object> notificationsSent;
    private final Map<GntpNotification, Integer> notificationRetries;

    public NioTcpGntpClient(GntpApplicationInfo applicationInfo, SocketAddress growlAddress, Executor executor, GntpListener listener, GntpPassword password, boolean encrypted, long retryTime, TimeUnit retryTimeUnit, int notificationRetryCount) {
        super(applicationInfo, growlAddress, password, encrypted);
        Preconditions.checkNotNull(executor, "Executor must not be null");
        if (retryTime > 0L) {
            Preconditions.checkNotNull(retryTimeUnit, "Retry time unit must not be null");
        }
        Preconditions.checkArgument(notificationRetryCount >= 0, "Notification retries must be equal or greater than zero");
        this.retryTime = retryTime;
        this.retryTimeUnit = retryTimeUnit;
        this.notificationRetryCount = notificationRetryCount;
        this.retryExecutorService = retryTime > 0L ? Executors.newSingleThreadScheduledExecutor() : null;
        this.bootstrap = new ClientBootstrap(new NioClientSocketChannelFactory(executor, executor));
        this.bootstrap.setPipelineFactory(new GntpChannelPipelineFactory(new GntpChannelHandler(this, listener)));
        this.bootstrap.setOption("tcpNoDelay", true);
        this.bootstrap.setOption("remoteAddress", growlAddress);
        this.bootstrap.setOption("soTimeout", 60000);
        this.bootstrap.setOption("receiveBufferSizePredictor", new AdaptiveReceiveBufferSizePredictor());
        this.channelGroup = new DefaultChannelGroup("jgntp");
        this.notificationIdGenerator = new AtomicLong();
        this.notificationsSent = HashBiMap.create();
        this.notificationRetries = Maps.newConcurrentMap();
    }

    @Override
    protected void doRegister() {
        this.bootstrap.connect().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                NioTcpGntpClient.this.tryingRegistration = false;
                if (future.isSuccess()) {
                    NioTcpGntpClient.this.channelGroup.add(future.getChannel());
                    GntpRegisterMessage message = new GntpRegisterMessage(NioTcpGntpClient.this.getApplicationInfo(), NioTcpGntpClient.this.getPassword(), NioTcpGntpClient.this.isEncrypted());
                    future.getChannel().write(message);
                }
            }
        });
    }

    @Override
    protected void doNotify(final GntpNotification notification) {
        this.bootstrap.connect().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    NioTcpGntpClient.this.channelGroup.add(future.getChannel());
                    long notificationId = NioTcpGntpClient.this.notificationIdGenerator.getAndIncrement();
                    NioTcpGntpClient.this.notificationsSent.put(notificationId, notification);
                    GntpNotifyMessage message = new GntpNotifyMessage(notification, notificationId, NioTcpGntpClient.this.getPassword(), NioTcpGntpClient.this.isEncrypted());
                    future.getChannel().write(message);
                } else {
                    if (NioTcpGntpClient.this.retryExecutorService != null) {
                        Integer count = (Integer)NioTcpGntpClient.this.notificationRetries.get(notification);
                        if (count == null) {
                            count = 1;
                        }
                        if (count <= NioTcpGntpClient.this.notificationRetryCount) {
                            logger.debug("Failed to send notification [{}], retry [{}/{}] in [{}-{}]", new Object[]{notification, count, NioTcpGntpClient.this.notificationRetryCount, NioTcpGntpClient.this.retryTime, NioTcpGntpClient.this.retryTimeUnit});
                            count = count + 1;
                            NioTcpGntpClient.this.notificationRetries.put(notification, count);
                            NioTcpGntpClient.this.retryExecutorService.schedule(new Runnable(){

                                @Override
                                public void run() {
                                    NioTcpGntpClient.this.notify(notification);
                                }
                            }, NioTcpGntpClient.this.retryTime, NioTcpGntpClient.this.retryTimeUnit);
                        } else {
                            logger.debug("Failed to send notification [{}], giving up", (Object)notification);
                            NioTcpGntpClient.this.notificationRetries.remove(notification);
                        }
                    }
                    NioTcpGntpClient.this.notificationsSent.inverse().remove(notification);
                }
            }
        });
    }

    @Override
    protected void doShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.retryExecutorService != null) {
            this.retryExecutorService.shutdownNow();
            this.retryExecutorService.awaitTermination(timeout, unit);
        }
        this.channelGroup.close().await(timeout, unit);
        this.bootstrap.releaseExternalResources();
    }

    @Override
    BiMap<Long, Object> getNotificationsSent() {
        return this.notificationsSent;
    }

    @Override
    void retryRegistration() {
        if (this.retryExecutorService != null && !this.tryingRegistration) {
            this.tryingRegistration = true;
            logger.info("Scheduling registration retry in [{}-{}]", (Object)this.retryTime, (Object)this.retryTimeUnit);
            this.retryExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    NioTcpGntpClient.this.register();
                }
            }, this.retryTime, this.retryTimeUnit);
        }
    }
}

