/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.io;

import com.google.code.jgntp.GntpApplicationInfo;
import com.google.code.jgntp.GntpNotification;
import com.google.code.jgntp.GntpPassword;
import com.google.code.jgntp.internal.io.GntpChannelHandler;
import com.google.code.jgntp.internal.io.GntpChannelPipelineFactory;
import com.google.code.jgntp.internal.io.NioGntpClient;
import com.google.code.jgntp.internal.message.GntpNotifyMessage;
import com.google.code.jgntp.internal.message.GntpRegisterMessage;
import com.shaded.notifier.google.common.base.Preconditions;
import com.shaded.notifier.google.common.collect.BiMap;
import com.shaded.notifier.google.common.collect.HashBiMap;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.oio.OioDatagramChannelFactory;

public class NioUdpGntpClient
extends NioGntpClient {
    private static final BiMap<Long, Object> notificationsSent = HashBiMap.create();
    private final ConnectionlessBootstrap bootstrap;
    private final DatagramChannel datagramChannel;

    public NioUdpGntpClient(GntpApplicationInfo applicationInfo, SocketAddress growlAddress, Executor executor, GntpPassword password, boolean encrypted) {
        super(applicationInfo, growlAddress, password, encrypted);
        Preconditions.checkNotNull(executor, "Executor must not be null");
        this.bootstrap = new ConnectionlessBootstrap(new OioDatagramChannelFactory(executor));
        this.bootstrap.setPipelineFactory(new GntpChannelPipelineFactory(new GntpChannelHandler(this, null)));
        this.bootstrap.setOption("broadcast", "false");
        this.datagramChannel = (DatagramChannel)this.bootstrap.bind(new InetSocketAddress(0));
    }

    @Override
    protected void doRegister() {
        GntpRegisterMessage message = new GntpRegisterMessage(this.getApplicationInfo(), this.getPassword(), this.isEncrypted());
        this.datagramChannel.write(message, this.getGrowlAddress());
        this.getRegistrationLatch().countDown();
    }

    @Override
    protected void doNotify(GntpNotification notification) {
        GntpNotifyMessage message = new GntpNotifyMessage(notification, -1L, this.getPassword(), this.isEncrypted());
        this.datagramChannel.write(message, this.getGrowlAddress());
    }

    @Override
    protected void doShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.datagramChannel.close().await(timeout, unit);
        this.bootstrap.releaseExternalResources();
    }

    @Override
    BiMap<Long, Object> getNotificationsSent() {
        return notificationsSent;
    }

    @Override
    void retryRegistration() {
    }
}

