/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.message;

import com.google.code.jgntp.GntpPassword;
import com.google.code.jgntp.internal.message.GntpId;
import com.google.code.jgntp.internal.message.GntpMessageHeader;
import com.google.code.jgntp.internal.message.GntpMessageType;
import com.google.code.jgntp.internal.message.write.AbstractGntpMessageWriter;
import com.google.code.jgntp.internal.message.write.ClearTextGntpMessageWriter;
import com.google.code.jgntp.internal.message.write.EncryptedGntpMessageWriter;
import com.google.code.jgntp.internal.message.write.GntpMessageWriter;
import com.google.code.jgntp.internal.util.Hex;
import com.shaded.notifier.google.common.base.CaseFormat;
import com.shaded.notifier.google.common.base.Charsets;
import com.shaded.notifier.google.common.collect.ImmutableList;
import com.shaded.notifier.google.common.collect.ImmutableMap;
import com.shaded.notifier.google.common.collect.Lists;
import com.shaded.notifier.google.common.collect.Maps;
import com.shaded.notifier.google.common.io.ByteStreams;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public abstract class GntpMessage {
    public static final String PROTOCOL_ID = "GNTP";
    public static final String SEPARATOR = "\r\n";
    public static final char HEADER_SEPARATOR = ':';
    public static final String NONE_ENCRYPTION_ALGORITHM = "NONE";
    public static final String BINARY_HASH_FUNCTION = "MD5";
    public static final Charset ENCODING = Charsets.UTF_8;
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String DATE_TIME_FORMAT_ALTERNATE = "yyyy-MM-dd HH:mm:ss'Z'";
    public static final String IMAGE_FORMAT = "png";
    public static final String BINARY_SECTION_ID = "Identifier:";
    public static final String BINARY_SECTION_LENGTH = "Length:";
    private final GntpMessageType type;
    private final GntpPassword password;
    private final boolean encrypt;
    private final Map<String, String> headers;
    private final List<BinarySection> binarySections;
    private final DateFormat dateFormat;
    private final StringBuilder buffer;

    public GntpMessage(GntpMessageType type, GntpPassword password, boolean encrypt) {
        this.type = type;
        this.password = password;
        this.encrypt = encrypt;
        this.headers = Maps.newHashMap();
        this.binarySections = Lists.newArrayList();
        this.dateFormat = new SimpleDateFormat(DATE_TIME_FORMAT);
        this.buffer = new StringBuilder();
    }

    public abstract void append(OutputStream var1) throws IOException;

    public void appendStatusLine(GntpMessageWriter writer) throws IOException {
        writer.writeStatusLine(this.type);
    }

    public void appendHeader(GntpMessageHeader header, Object value, GntpMessageWriter writer) throws IOException {
        this.appendHeader(header.toString(), value, writer);
    }

    public void appendHeader(String name, Object value, GntpMessageWriter writer) throws IOException {
        this.buffer.append(name).append(':').append(' ');
        if (value != null) {
            if (value instanceof String) {
                String s = (String)value;
                s = s.replaceAll(SEPARATOR, "\n");
                this.buffer.append(s);
            } else if (value instanceof Number) {
                this.buffer.append(((Number)value).toString());
            } else if (value instanceof Boolean) {
                String s = ((Boolean)value).toString();
                s = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, s);
                this.buffer.append(s);
            } else if (value instanceof Date) {
                String s = this.dateFormat.format((Date)value);
                this.buffer.append(s);
            } else if (value instanceof URI) {
                this.buffer.append(((URI)value).toString());
            } else if (value instanceof GntpId) {
                this.buffer.append(value.toString());
            } else if (value instanceof InputStream) {
                byte[] data = ByteStreams.toByteArray((InputStream)value);
                GntpId id = this.addBinary(data);
                this.buffer.append(id.toString());
            } else if (value instanceof byte[]) {
                byte[] data = (byte[])value;
                GntpId id = this.addBinary(data);
                this.buffer.append(id.toString());
            } else {
                throw new IllegalArgumentException("Value of header [" + name + "] not supported: " + value);
            }
        }
        writer.writeHeaderLine(this.buffer.toString());
        this.buffer.setLength(0);
    }

    public boolean appendIcon(GntpMessageHeader header, RenderedImage image, URI uri, GntpMessageWriter writer) throws IOException {
        if (image == null && uri == null) {
            return false;
        }
        if (image == null) {
            this.appendHeader(header, (Object)uri, writer);
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            if (!ImageIO.write(image, IMAGE_FORMAT, output)) {
                throw new IllegalStateException("Could not read icon data");
            }
            this.appendHeader(header, (Object)output.toByteArray(), writer);
        }
        return true;
    }

    public GntpId addBinary(byte[] data) throws IOException {
        BinarySection binarySection = new BinarySection(data);
        this.binarySections.add(binarySection);
        return GntpId.of(binarySection.getId());
    }

    public void appendBinarySections(GntpMessageWriter writer) throws IOException {
        Iterator<BinarySection> iter = this.binarySections.iterator();
        while (iter.hasNext()) {
            BinarySection binarySection = iter.next();
            writer.writeBinarySection(binarySection);
            if (!iter.hasNext()) continue;
            this.appendSeparator(writer);
            this.appendSeparator(writer);
        }
    }

    public void appendSeparator(GntpMessageWriter writer) throws IOException {
        writer.writeSeparator();
    }

    public void clearBinarySections() {
        this.binarySections.clear();
    }

    public void putHeaders(Map<String, String> map) {
        this.headers.putAll(map);
    }

    public Map<String, String> getHeaders() {
        return ImmutableMap.copyOf(this.headers);
    }

    public List<BinarySection> getBinarySections() {
        return ImmutableList.copyOf(this.binarySections);
    }

    protected GntpMessageWriter getWriter(OutputStream output) {
        AbstractGntpMessageWriter messageWriter = this.encrypt ? new EncryptedGntpMessageWriter() : new ClearTextGntpMessageWriter();
        messageWriter.prepare(output, this.password);
        return messageWriter;
    }

    public static class BinarySection {
        private final String id;
        private final byte[] data;

        public BinarySection(byte[] data) throws IOException {
            this.data = data;
            try {
                MessageDigest digest = MessageDigest.getInstance(GntpMessage.BINARY_HASH_FUNCTION);
                digest.update(data);
                byte[] digested = digest.digest();
                this.id = Hex.toHexadecimal(digested);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        public String getId() {
            return this.id;
        }

        public byte[] getData() {
            return this.data;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BinarySection other = (BinarySection)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }
}

