/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.message;

import com.google.code.jgntp.GntpNotification;
import com.google.code.jgntp.GntpPassword;
import com.google.code.jgntp.internal.message.GntpMessage;
import com.google.code.jgntp.internal.message.GntpMessageHeader;
import com.google.code.jgntp.internal.message.GntpMessageType;
import com.google.code.jgntp.internal.message.write.GntpMessageWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class GntpNotifyMessage
extends GntpMessage {
    private final GntpNotification notification;
    private final long notificationId;

    public GntpNotifyMessage(GntpNotification notification, long notificationId, GntpPassword password, boolean encrypt) {
        super(GntpMessageType.NOTIFY, password, encrypt);
        this.notification = notification;
        this.notificationId = notificationId;
    }

    @Override
    public void append(OutputStream output) throws IOException {
        GntpMessageWriter writer = this.getWriter(output);
        this.appendStatusLine(writer);
        this.appendSeparator(writer);
        writer.startHeaders();
        this.appendHeader(GntpMessageHeader.APPLICATION_NAME, (Object)this.notification.getApplicationName(), writer);
        this.appendSeparator(writer);
        this.appendHeader(GntpMessageHeader.NOTIFICATION_NAME, (Object)this.notification.getName(), writer);
        this.appendSeparator(writer);
        this.appendHeader(GntpMessageHeader.NOTIFICATION_TITLE, (Object)this.notification.getTitle(), writer);
        this.appendSeparator(writer);
        if (this.notification.getId() != null) {
            this.appendHeader(GntpMessageHeader.NOTIFICATION_ID, (Object)this.notification.getId(), writer);
            this.appendSeparator(writer);
        }
        if (this.notification.getText() != null) {
            this.appendHeader(GntpMessageHeader.NOTIFICATION_TEXT, (Object)this.notification.getText(), writer);
            this.appendSeparator(writer);
        }
        if (this.notification.isSticky() != null) {
            this.appendHeader(GntpMessageHeader.NOTIFICATION_STICKY, (Object)this.notification.isSticky(), writer);
            this.appendSeparator(writer);
        }
        if (this.notification.getPriority() != null) {
            this.appendHeader(GntpMessageHeader.NOTIFICATION_PRIORITY, (Object)this.notification.getPriority().getCode(), writer);
            this.appendSeparator(writer);
        }
        if (this.appendIcon(GntpMessageHeader.NOTIFICATION_ICON, this.notification.getIconImage(), this.notification.getIconUri(), writer)) {
            this.appendSeparator(writer);
        }
        if (this.notification.getCoalescingId() != null) {
            this.appendHeader(GntpMessageHeader.NOTIFICATION_COALESCING_ID, (Object)this.notification.getCoalescingId(), writer);
            this.appendSeparator(writer);
        }
        if (this.notification.getCallbackTarget() != null) {
            this.appendHeader(GntpMessageHeader.NOTIFICATION_CALLBACK_TARGET, (Object)this.notification.getCallbackTarget(), writer);
            this.appendSeparator(writer);
        }
        if (this.notification.isCallbackRequested()) {
            this.appendHeader(GntpMessageHeader.NOTIFICATION_CALLBACK_CONTEXT, (Object)this.notificationId, writer);
            this.appendSeparator(writer);
            this.appendHeader(GntpMessageHeader.NOTIFICATION_CALLBACK_CONTEXT_TYPE, (Object)"int", writer);
            this.appendSeparator(writer);
        }
        this.appendHeader(GntpMessageHeader.NOTIFICATION_INTERNAL_ID, (Object)this.notificationId, writer);
        this.appendSeparator(writer);
        for (Map.Entry<String, Object> customHeader : this.notification.getCustomHeaders().entrySet()) {
            this.appendHeader(customHeader.getKey(), customHeader.getValue(), writer);
            this.appendSeparator(writer);
        }
        if (!this.getBinarySections().isEmpty()) {
            this.appendSeparator(writer);
        }
        writer.finishHeaders();
        this.appendBinarySections(writer);
        this.clearBinarySections();
    }
}

