/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.message;

import com.google.code.jgntp.GntpApplicationInfo;
import com.google.code.jgntp.GntpNotificationInfo;
import com.google.code.jgntp.GntpPassword;
import com.google.code.jgntp.internal.message.GntpMessage;
import com.google.code.jgntp.internal.message.GntpMessageHeader;
import com.google.code.jgntp.internal.message.GntpMessageType;
import com.google.code.jgntp.internal.message.write.GntpMessageWriter;
import java.io.IOException;
import java.io.OutputStream;

public class GntpRegisterMessage
extends GntpMessage {
    private final GntpApplicationInfo info;

    public GntpRegisterMessage(GntpApplicationInfo applicationInfo, GntpPassword password, boolean encrypt) {
        super(GntpMessageType.REGISTER, password, encrypt);
        this.info = applicationInfo;
    }

    @Override
    public void append(OutputStream output) throws IOException {
        GntpMessageWriter writer = this.getWriter(output);
        this.appendStatusLine(writer);
        this.appendSeparator(writer);
        writer.startHeaders();
        this.appendHeader(GntpMessageHeader.APPLICATION_NAME, (Object)this.info.getName(), writer);
        this.appendSeparator(writer);
        if (this.appendIcon(GntpMessageHeader.APPLICATION_ICON, this.info.getIconImage(), this.info.getIconUri(), writer)) {
            this.appendSeparator(writer);
        }
        this.appendHeader(GntpMessageHeader.NOTIFICATION_COUNT, (Object)this.info.getNotificationInfos().size(), writer);
        this.appendSeparator(writer);
        this.appendSeparator(writer);
        for (GntpNotificationInfo notificationInfo : this.info.getNotificationInfos()) {
            this.appendHeader(GntpMessageHeader.NOTIFICATION_NAME, (Object)notificationInfo.getName(), writer);
            this.appendSeparator(writer);
            if (notificationInfo.getDisplayName() != null) {
                this.appendHeader(GntpMessageHeader.NOTIFICATION_DISPLAY_NAME, (Object)notificationInfo.getDisplayName(), writer);
                this.appendSeparator(writer);
            }
            if (this.appendIcon(GntpMessageHeader.NOTIFICATION_ICON, notificationInfo.getIconImage(), notificationInfo.getIconUri(), writer)) {
                this.appendSeparator(writer);
            }
            this.appendHeader(GntpMessageHeader.NOTIFICATION_ENABLED, (Object)notificationInfo.isEnabled(), writer);
            this.appendSeparator(writer);
            this.appendSeparator(writer);
        }
        writer.finishHeaders();
        this.appendBinarySections(writer);
        this.clearBinarySections();
    }
}

