/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.message.read;

import com.google.code.jgntp.GntpErrorStatus;
import com.google.code.jgntp.internal.message.GntpCallbackMessage;
import com.google.code.jgntp.internal.message.GntpCallbackResult;
import com.google.code.jgntp.internal.message.GntpErrorMessage;
import com.google.code.jgntp.internal.message.GntpMessageHeader;
import com.google.code.jgntp.internal.message.GntpMessageResponse;
import com.google.code.jgntp.internal.message.GntpMessageType;
import com.google.code.jgntp.internal.message.GntpOkMessage;
import com.google.code.jgntp.internal.message.GntpVersion;
import com.shaded.notifier.google.common.base.Preconditions;
import com.shaded.notifier.google.common.base.Splitter;
import com.shaded.notifier.google.common.collect.Iterables;
import com.shaded.notifier.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GntpMessageResponseParser {
    private Splitter separatorSplitter = Splitter.on("\r\n").omitEmptyStrings();
    private Splitter statusLineSplitter = Splitter.on(' ').omitEmptyStrings().trimResults();

    public GntpMessageResponse parse(String s) {
        Iterable<String> splitted = this.separatorSplitter.split(s);
        Preconditions.checkState(!Iterables.isEmpty(splitted), "Empty message received from Growl");
        Iterator<String> iter = splitted.iterator();
        String statusLine = iter.next();
        Preconditions.checkState(statusLine.startsWith("GNTP/" + GntpVersion.ONE_DOT_ZERO.toString()), "Unknown protocol version");
        Iterable<String> statusLineIterable = this.statusLineSplitter.split(statusLine);
        String messageTypeText = Iterables.get(statusLineIterable, 1).substring(1);
        GntpMessageType messageType = GntpMessageType.valueOf(messageTypeText);
        HashMap<String, String> headers = Maps.newHashMap();
        while (iter.hasNext()) {
            String[] splittedHeader = iter.next().split(":", 2);
            headers.put(splittedHeader[0], splittedHeader[1].trim());
        }
        switch (messageType) {
            case OK: {
                return this.createOkMessage(headers);
            }
            case CALLBACK: {
                return this.createCallbackMessage(headers);
            }
            case ERROR: {
                return this.createErrorMessage(headers);
            }
        }
        throw new IllegalStateException("Unknown response message type: " + (Object)((Object)messageType));
    }

    protected GntpOkMessage createOkMessage(Map<String, String> headers) {
        String notificationId = GntpMessageHeader.NOTIFICATION_ID.getValueInMap(headers);
        return new GntpOkMessage(this.getInternalNotificationId(headers), this.getRespondingType(headers), notificationId);
    }

    protected GntpCallbackMessage createCallbackMessage(Map<String, String> headers) {
        String notificationId = GntpMessageHeader.NOTIFICATION_ID.getValueInMap(headers);
        String callbackResultText = GntpMessageHeader.NOTIFICATION_CALLBACK_RESULT.getRequiredValueInMap(headers);
        GntpCallbackResult callbackResult = GntpCallbackResult.parse(callbackResultText);
        String context = GntpMessageHeader.NOTIFICATION_CALLBACK_CONTEXT.getRequiredValueInMap(headers);
        String contextType = GntpMessageHeader.NOTIFICATION_CALLBACK_CONTEXT_TYPE.getRequiredValueInMap(headers);
        String timestampText = GntpMessageHeader.NOTIFICATION_CALLBACK_TIMESTAMP.getRequiredValueInMap(headers);
        Date timestamp = null;
        try {
            timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(timestampText);
        }
        catch (ParseException e) {
            try {
                timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss'Z'").parse(timestampText);
            }
            catch (ParseException e1) {
                throw new RuntimeException(e);
            }
        }
        return new GntpCallbackMessage(this.getInternalNotificationId(headers), notificationId, callbackResult, context, contextType, timestamp);
    }

    protected GntpErrorMessage createErrorMessage(Map<String, String> headers) {
        String code = GntpMessageHeader.ERROR_CODE.getRequiredValueInMap(headers);
        String description = GntpMessageHeader.ERROR_DESCRIPTION.getRequiredValueInMap(headers);
        GntpErrorStatus errorStatus = GntpErrorStatus.parse(code);
        return new GntpErrorMessage(this.getInternalNotificationId(headers), this.getRespondingType(headers), errorStatus, description);
    }

    protected long getInternalNotificationId(Map<String, String> headers) {
        String value = GntpMessageHeader.NOTIFICATION_INTERNAL_ID.getValueInMap(headers);
        return value == null ? -1L : Long.parseLong(value);
    }

    protected GntpMessageType getRespondingType(Map<String, String> headers) {
        String respondingTypeName = GntpMessageHeader.RESPONSE_ACTION.getValueInMap(headers);
        return respondingTypeName == null ? null : GntpMessageType.valueOf(respondingTypeName);
    }
}

