/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.message.write;

import com.google.code.jgntp.GntpPassword;
import com.google.code.jgntp.internal.message.GntpMessage;
import com.google.code.jgntp.internal.message.GntpMessageType;
import com.google.code.jgntp.internal.message.GntpVersion;
import com.google.code.jgntp.internal.message.write.GntpMessageWriter;
import com.google.code.jgntp.internal.util.Hex;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public abstract class AbstractGntpMessageWriter
implements GntpMessageWriter {
    protected OutputStream output;
    protected OutputStreamWriter writer;
    protected GntpPassword password;

    @Override
    public void prepare(OutputStream outputStream, GntpPassword gntpPassword) {
        this.output = outputStream;
        this.writer = new OutputStreamWriter(outputStream, GntpMessage.ENCODING);
        this.password = gntpPassword;
    }

    @Override
    public void writeStatusLine(GntpMessageType type) throws IOException {
        this.writer.append("GNTP").append('/').append(GntpVersion.ONE_DOT_ZERO.toString());
        this.writer.append(' ').append(type.toString());
        this.writer.append(' ');
        this.writeEncryptionSpec();
        if (this.password != null) {
            this.writer.append(' ').append(this.password.getKeyHashAlgorithm());
            this.writer.append(':').append(Hex.toHexadecimal(this.password.getKeyHash()));
            this.writer.append('.').append(Hex.toHexadecimal(this.password.getSalt()));
        }
    }

    @Override
    public void startHeaders() throws IOException {
        this.writer.flush();
    }

    @Override
    public void writeHeaderLine(String line) throws IOException {
        this.writer.append(line);
    }

    @Override
    public void finishHeaders() throws IOException {
        this.writer.flush();
    }

    @Override
    public void writeBinarySection(GntpMessage.BinarySection binarySection) throws IOException {
        byte[] data = this.getDataForBinarySection(binarySection);
        this.writer.append("Identifier:").append(' ').append(binarySection.getId());
        this.writeSeparator();
        this.writer.append("Length:").append(' ').append(Long.toString(data.length));
        this.writeSeparator();
        this.writeSeparator();
        this.writer.flush();
        this.output.write(data);
    }

    @Override
    public void writeSeparator() throws IOException {
        this.writer.append("\r\n");
    }

    protected abstract void writeEncryptionSpec() throws IOException;

    protected abstract byte[] getDataForBinarySection(GntpMessage.BinarySection var1);
}

