/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.message.write;

import com.google.code.jgntp.GntpPassword;
import com.google.code.jgntp.internal.message.GntpMessage;
import com.google.code.jgntp.internal.message.write.AbstractGntpMessageWriter;
import com.google.code.jgntp.internal.util.Hex;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;

public class EncryptedGntpMessageWriter
extends AbstractGntpMessageWriter {
    public static final String DEFAULT_ALGORITHM = "DES";
    public static final String DEFAULT_TRANSFORMATION = "DES/CBC/PKCS5Padding";
    private Cipher cipher;
    private SecretKey secretKey;
    private IvParameterSpec iv;
    private ChannelBuffer buffer;

    @Override
    public void prepare(OutputStream outputStream, GntpPassword gntpPassword) {
        super.prepare(outputStream, gntpPassword);
        this.buffer = ChannelBuffers.dynamicBuffer();
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DEFAULT_ALGORITHM);
            this.secretKey = keyFactory.generateSecret(new DESKeySpec(gntpPassword.getKey()));
            this.iv = new IvParameterSpec(this.secretKey.getEncoded());
            this.cipher = Cipher.getInstance(DEFAULT_TRANSFORMATION);
            this.cipher.init(1, (Key)this.secretKey, this.iv);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void writeEncryptionSpec() throws IOException {
        this.writer.append(DEFAULT_ALGORITHM).append(':').append(Hex.toHexadecimal(this.iv.getIV()));
    }

    @Override
    public void startHeaders() throws IOException {
        super.startHeaders();
        this.writer = new OutputStreamWriter((OutputStream)new ChannelBufferOutputStream(this.buffer), GntpMessage.ENCODING);
    }

    @Override
    public void finishHeaders() throws IOException {
        super.finishHeaders();
        byte[] headerData = new byte[this.buffer.readableBytes()];
        this.buffer.getBytes(0, headerData);
        byte[] encryptedHeaderData = this.encrypt(headerData);
        this.output.write(encryptedHeaderData);
        this.writer = new OutputStreamWriter(this.output, GntpMessage.ENCODING);
        this.writeSeparator();
        this.writeSeparator();
    }

    @Override
    protected byte[] getDataForBinarySection(GntpMessage.BinarySection binarySection) {
        return this.encrypt(binarySection.getData());
    }

    protected byte[] encrypt(byte[] data) {
        try {
            return this.cipher.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

