/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.jgntp.internal.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class MultiOutputStream
extends OutputStream {
    private final OutputStream[] outputStreams;

    public MultiOutputStream(OutputStream ... outputStreams) {
        this.outputStreams = Arrays.copyOf(outputStreams, outputStreams.length);
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.close();
        }
    }

    public OutputStream[] getOutputStreams() {
        return Arrays.copyOf(this.outputStreams, this.outputStreams.length);
    }
}

