/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.mimecraft;

import com.squareup.mimecraft.Part;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;

public final class FormEncoding
implements Part {
    private static final Map<String, String> HEADERS = Collections.singletonMap("Content-Type", "application/x-www-form-urlencoded");
    private final byte[] data;

    private FormEncoding(String data) {
        try {
            this.data = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unable to convert input to UTF-8: " + data, e);
        }
    }

    @Override
    public Map<String, String> getHeaders() {
        return HEADERS;
    }

    @Override
    public void writeBodyTo(OutputStream stream) throws IOException {
        stream.write(this.data);
    }

    public static class Builder {
        private final StringBuilder content = new StringBuilder();

        public Builder add(String name, String value) {
            if (this.content.length() > 0) {
                this.content.append('&');
            }
            try {
                this.content.append(URLEncoder.encode(name, "UTF-8")).append('=').append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
            return this;
        }

        public FormEncoding build() {
            if (this.content.length() == 0) {
                throw new IllegalStateException("Form encoded body must have at least one part.");
            }
            return new FormEncoding(this.content.toString());
        }
    }
}

