/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.mimecraft;

import com.squareup.mimecraft.Multipart;
import com.squareup.mimecraft.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;

public interface Part {
    public Map<String, String> getHeaders();

    public void writeBodyTo(OutputStream var1) throws IOException;

    public static class Builder {
        private static final int BUFFER_SIZE = 4096;
        private String headerType;
        int headerLength;
        private String headerLanguage;
        private String headerEncoding;
        private String headerDisposition;
        private File bodyFile;
        private InputStream bodyStream;
        private byte[] bodyBytes;
        private Multipart bodyMultipart;
        private boolean hasBody = false;

        private void checkSetBody() {
            if (this.hasBody) {
                throw new IllegalStateException("Only one body per part.");
            }
            this.hasBody = true;
        }

        public Builder contentType(String type) {
            Utils.isNotEmpty(type, "Type must not be empty.");
            Utils.isNull(this.headerType, "Type header already set.");
            Utils.isNull(this.bodyMultipart, "Type cannot be set with multipart body.");
            this.headerType = type;
            return this;
        }

        public Builder contentLength(int length) {
            if (length <= 0) {
                throw new IllegalStateException("Length must be greater than zero.");
            }
            Utils.isNotZero(this.headerLength, "Length header already set.");
            this.headerLength = length;
            return this;
        }

        public Builder contentLanguage(String language) {
            Utils.isNotEmpty(language, "Language must not be empty.");
            Utils.isNull(this.headerLanguage, "Language header already set.");
            this.headerLanguage = language;
            return this;
        }

        public Builder contentEncoding(String encoding) {
            Utils.isNotEmpty(encoding, "Encoding must not be empty.");
            Utils.isNull(this.headerEncoding, "Encoding header already set.");
            this.headerEncoding = encoding;
            return this;
        }

        public Builder contentDisposition(String disposition) {
            Utils.isNotEmpty(disposition, "Disposition must not be empty.");
            Utils.isNull(this.headerDisposition, "Disposition header already set.");
            this.headerDisposition = disposition;
            return this;
        }

        public Builder body(File body) {
            Utils.isNotNull(body, "File body must not be null.");
            this.checkSetBody();
            this.bodyFile = body;
            return this;
        }

        public Builder body(InputStream body) {
            Utils.isNotNull(body, "Stream body must not be null.");
            this.checkSetBody();
            this.bodyStream = body;
            return this;
        }

        public Builder body(String body) {
            byte[] bytes;
            Utils.isNotNull(body, "String body must not be null.");
            this.checkSetBody();
            try {
                bytes = body.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Unable to convert input to UTF-8: " + body, e);
            }
            this.bodyBytes = bytes;
            this.headerLength = bytes.length;
            return this;
        }

        public Builder body(byte[] body) {
            Utils.isNotNull(body, "Byte array body must not be null.");
            this.checkSetBody();
            this.bodyBytes = body;
            this.headerLength = body.length;
            return this;
        }

        public Builder body(Multipart body) {
            Utils.isNotNull(body, "Multipart body must not be null.");
            if (this.headerType != null) {
                throw new IllegalStateException("Content type must not be explicitly set for multipart body.");
            }
            this.checkSetBody();
            this.headerType = null;
            this.bodyMultipart = body;
            return this;
        }

        public Part build() {
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            if (this.headerDisposition != null) {
                headers.put("Content-Disposition", this.headerDisposition);
            }
            if (this.headerType != null) {
                headers.put("Content-Type", this.headerType);
            }
            if (this.headerLength != 0) {
                headers.put("Content-Length", Integer.toString(this.headerLength));
            }
            if (this.headerLanguage != null) {
                headers.put("Content-Language", this.headerLanguage);
            }
            if (this.headerEncoding != null) {
                headers.put("Content-Transfer-Encoding", this.headerEncoding);
            }
            if (this.bodyBytes != null) {
                return new BytesPart(headers, this.bodyBytes);
            }
            if (this.bodyStream != null) {
                return new StreamPart(headers, this.bodyStream);
            }
            if (this.bodyFile != null) {
                return new FilePart(headers, this.bodyFile);
            }
            if (this.bodyMultipart != null) {
                headers.putAll(this.bodyMultipart.getHeaders());
                return new PartPart(headers, this.bodyMultipart);
            }
            throw new IllegalStateException("Part required body to be set.");
        }

        private static final class FilePart
        extends PartImpl {
            private final File file;
            private final byte[] buffer = new byte[4096];

            private FilePart(Map<String, String> headers, File file) {
                super(headers);
                this.file = file;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeBodyTo(OutputStream out) throws IOException {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(this.file);
                    Utils.copyStream(in, out, this.buffer);
                }
                finally {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        private static final class StreamPart
        extends PartImpl {
            private final InputStream in;
            private final byte[] buffer = new byte[4096];

            private StreamPart(Map<String, String> headers, InputStream in) {
                super(headers);
                this.in = in;
            }

            @Override
            public void writeBodyTo(OutputStream out) throws IOException {
                Utils.copyStream(this.in, out, this.buffer);
            }
        }

        static final class BytesPart
        extends PartImpl {
            private final byte[] contents;

            BytesPart(Map<String, String> headers, byte[] contents) {
                super(headers);
                this.contents = contents;
            }

            @Override
            public void writeBodyTo(OutputStream out) throws IOException {
                out.write(this.contents);
            }
        }

        private static final class PartPart
        extends PartImpl {
            private final Part body;

            protected PartPart(Map<String, String> headers, Part body) {
                super(headers);
                this.body = body;
            }

            @Override
            public void writeBodyTo(OutputStream stream) throws IOException {
                this.body.writeBodyTo(stream);
            }
        }

        private static abstract class PartImpl
        implements Part {
            private final Map<String, String> headers;

            protected PartImpl(Map<String, String> headers) {
                this.headers = headers;
            }

            @Override
            public Map<String, String> getHeaders() {
                return this.headers;
            }
        }
    }
}

